% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlong_to_rayshader_coords.R
\name{latlong_to_rayshader_coords}
\alias{latlong_to_rayshader_coords}
\title{Converts WGS84 lat long points into 'rayshader' coordinates. Useful for adding arbitrary points and text to a 'rayshader' scene.}
\usage{
latlong_to_rayshader_coords(raster_input, lat, long)
}
\arguments{
\item{raster_input}{a raster}

\item{lat}{vector of WGS84 latitude points}

\item{long}{vector of WGS84 longitude points}
}
\value{
A tibble with x,y in 'rayshader' coordinates
}
\description{
Converts WGS84 lat long points into 'rayshader' coordinates. Useful for adding arbitrary points and text to a 'rayshader' scene.
}
\examples{
latlong_to_rayshader_coords(example_raster(), example_igc()$lat, example_igc()$long)
}
