% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortCrit.R
\name{sortCrit}
\alias{sortCrit}
\title{sortCrit called by correctionTree}
\usage{
sortCrit(qProb, crit, cost, costL, nz, mdist, listOfZ, map, disp = 0,
  SAVE = FALSE)
}
\arguments{
\item{qProb}{probability vector used to generate quantile values}

\item{crit}{list of criteria}

\item{cost}{list of costs}

\item{costL}{list of per label costs}

\item{nz}{list of number of zones}

\item{mdist}{list of distance matrices}

\item{listOfZ}{list of zoning objects}

\item{map}{object returned by function genMap}

\item{disp}{0: no info, 1: plot best corrected zoning}

\item{SAVE}{logical value, if TRUE function returns more elements}
}
\value{
a list with components
\describe{
\item{bestcrit}{best criterion value at last level}
\item{critList}{criterion values at last level}
\item{costList}{cost values at last level}
\item{costLList}{cost per label  values at last level}
\item{nzList}{vector of number of zones at last level}
\item{qProb}{vector of probabilities values used for quantiles}
\item{zk}{(SAVE=TRUE) list of zoning objects (such as returned by calNei function), first element corresponds to initial zoning, each other element is a list with each (last if ALL=FALSE) level zoning objects}
\item{mdist}{(SAVE=TRUE) list of initial distance matrix and all (last if ALL=FALSE) level distance matrices}
\item{crit}{(SAVE=TRUE) list of initial criterion and all (last if ALL=FALSE) level criteria }
\item{cost}{(SAVE=TRUE) list of initial cost and all (last if ALL=FALSE) level costs  }
\item{costL}{(SAVE=TRUE) list of initial cost per label and all (last if ALL=FALSE) level costs per label}
\item{nz}{(SAVE=TRUE) list of initial number of zones and all (last if ALL=FALSE) level number of zones}
}
}
\description{
sortCrit called by correctionTree
}
\details{
sort last level criteria from list of zonings, return criteria and list of zonings if SAVE=TRUE, otherwise only return last level criteria
}
\examples{
data(mapTest)
qProb=c(0.4,0.7)
criti=correctionTree(qProb,mapTest)
# displays best criterion, corresponding costs and number of zones
geozoning:::sortCrit(qProb,criti$criterion,criti$cost,criti$costL,
            criti$nz,criti$mdist,criti$zk,mapTest)
}
\keyword{internal}
