% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimsonsIndex.R
\name{TimsonsIndex}
\alias{TimsonsIndex}
\alias{GermRateGeorge}
\title{Timson's index}
\usage{
TimsonsIndex(germ.counts, intervals, partial = TRUE, total.seeds, max,
  modification = c("none", "labouriau", "khanunger"))

GermRateGeorge(germ.counts, intervals, partial = TRUE, max)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{total.seeds}{Total number of seeds.}

\item{max}{The maximum interval value up to which Timson's index/George's
germination rate is to be computed.}

\item{modification}{The modification to be applied. Either \code{"none"},
\code{"labouriau"} or \code{"khanunger"}. Default is \code{"none"} (see
\strong{Details}).}
}
\value{
For \code{TimsonsIndex} The value of Timson's index.

  For \code{GermRateGeorge} The value of George's germination rate.
}
\description{
Compute George's index
\insertCite{george_influence_1961;textual}{germinationmetrics}, Timson's
index or Timson's germination velocity index
\insertCite{timson_new_1965}{germinationmetrics} and it's modifications by
Labouriau \insertCite{ranal_how_2006}{germinationmetrics} and
\insertCite{khan_effect_1984}{germinationmetrics}.
}
\details{
Timson's index \insertCite{timson_new_1965}{germinationmetrics} is computed
as follows
\insertCite{brown_representing_1988,baskin_seeds:_1998}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em>&sum;n =
&sum;<sup>t</sup><sub style="line-height: 1.8; margin-left: -1ex;">i=1
</sub>G<sub>i</sub></em></p>}}{\deqn{\sum n = \sum_{i=1}^{t}G_{i}}}

Where, \ifelse{html}{\out{<i>G<sub>i</sub></i>}}{\eqn{G_{i}}} is the
cumulative germination percentage in time interval
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}} and
\ifelse{html}{\out{<i>t</i>}}{\eqn{t}} is the total number of time intervals.

For example ten summation (\eqn{\Sigma 10}) is expressed as follows:

\ifelse{html}{\out{<p style="text-align: center;"><em>&sum; 10 =
G<sub>1</sub> + G<sub>2</sub> + G<sub>3</sub> +&hellip;+
G<sub>10</sub></em></p>}}{\deqn{\sum 10 = G_{1}+G_{2}+\cdots+G_{10}}}

Where \ifelse{html}{\out{<em>G<sub>1</sub>, G<sub>2</sub>, G<sub>3</sub>,
&hellip; G<sub>10</sub></em>}}{\eqn{G_{1},G_{2},\cdots G_{10}}} are the
cumulative germination percentage at day 1, 2, 3,
\ifelse{html}{\out{&hellip;}}{\eqn{\cdots}}, 10 respectively.

Similarly \eqn{\Sigma 5} or \eqn{\Sigma 20} can be estimated. For \eqn{\Sigma
10}, the value can range from 0 (no germination) to 1,000 (100\% germination
after 24 hours).

It is the progressive total of cumulative germination percentage recorded at
specific intervals for a set period of time.  It combines onset, rate and
total percentage of germination and estimates the area under the cumulative
germination percentage curve.

\insertCite{goodchild_method_1971;textual}{germinationmetrics}, described the
same in terms of partial germination percentage as follows:

\ifelse{html}{\out{<p style="text-align: center;"><em>&sum;n =
&sum;<sup>t</sup><sub style="line-height: 1.8; margin-left: -1ex;">i=1 </sub>
g<sub>i</sub>(t-j)</em></p>}}{\deqn{\sum n = \sum_{i=1}^{t}g_{i}(t-j)}}

Where, \ifelse{html}{\out{<i>g<sub>i</sub></i>}}{\eqn{g_{i}}} is the
germination (not cumulative, but partial germination) in time interval
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}
(\ifelse{html}{\out{<i>i</i>}}{\eqn{i}} varying from
\ifelse{html}{\out{<i>0</i>}}{\eqn{0}} to
\ifelse{html}{\out{<i>t</i>}}{\eqn{t}}) and
\ifelse{html}{\out{<i>t</i>}}{\eqn{t}} is the total number of time intervals
and \ifelse{html}{\out{<i>j = i - 1</i>}}{\eqn{j = i - 1}}.

Timson's index is similar to the germination rate proposed by
\insertCite{george_influence_1961;textual}{germinationmetrics} as follows
\insertCite{tucker_estimating_1965,nichols_two_1968}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;"><em>GR =
&sum;<sup>t</sup><sub style="line-height: 1.8; margin-left: -1ex;">i=1 </sub>
N<sub>i</sub>K<sub>i</sub></em></p>}}{\deqn{GR = \sum_{i=1}^{t}N_{i}K_{i}}}

Where \ifelse{html}{\out{<em>N<sub>i</sub></em>}}{\eqn{N_{i}}} is the number
of seeds germinated by \ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th interval and
\ifelse{html}{\out{<em>K<sub>i</sub></em>}}{\eqn{K_{i}}} is the number of
intervals(e.g. days) until the end of the test.

This index uses number of seeds germinated instead of germination percentage.

As Timson's index is useful for comparison only when samples have similar
germinabilities or final germination percentage, the following modification
was suggested by Labouriau \insertCite{ranal_how_2006}{germinationmetrics}.

\ifelse{html}{\out{<p style="text-align: center;">T<sub>mod</sub> =
<sup>T</sup> &frasl; <sub>&sum;<sup>t</sup><sub style="line-height: 1.8;
margin-left: -1ex;">i=1 </sub>g<sub>i</sub></sub></p>}}{\deqn{T_{mod} =
\frac{T}{\sum_{i=1}^{t}g_{i}}}}

Here Timson's index (\ifelse{html}{\out{<i>t</i>}}{\eqn{t}}) is divided by
the sum of partial germination percentages.

Similarly another modification was proposed by
\insertCite{khan_effect_1984}{germinationmetrics}, where Timson's index
(\ifelse{html}{\out{<i>t</i>}}{\eqn{t}}) is divided by number of intervals
(\ifelse{html}{\out{<i>t</i>}}{\eqn{t}}).

\ifelse{html}{\out{<p style="text-align: center;">T<sub>mod</sub> =
<sup>T</sup> &frasl; <sub>t</sub></p>}}{\deqn{T_{mod} = \frac{T}{t}}}
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
# Wihout max specified
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50)
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50,
             modification = "none")
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50,
             modification = "labouriau")
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50,
             modification = "khanunger")
# With max specified
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50, max = 10)
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50,
             max = 10, modification = "none")
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50,
             max = 10, modification = "labouriau")
TimsonsIndex(germ.counts = x, intervals = int, total.seeds = 50,
             max = 10, modification = "khanunger")

# Wihout max specified
GermRateGeorge(germ.counts = x, intervals = int)
# With max specified
GermRateGeorge(germ.counts = x, intervals = int, max = 10)
GermRateGeorge(germ.counts = x, intervals = int, max = 14)

# From cumulative germination counts
#----------------------------------------------------------------------------


# Wihout max specified
GermRateGeorge(germ.counts = x, intervals = int, partial = TRUE)
# With max specified
GermRateGeorge(germ.counts = x, intervals = int, partial = TRUE, max = 10)
GermRateGeorge(germ.counts = x, intervals = int, partial = TRUE, max = 14)
}
\references{
\insertAllCited{}
}
