% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_constructors.R
\name{PieceRMaxF}
\alias{PieceRMaxF}
\title{PieceR RCurve constructor function}
\usage{
PieceRMaxF(recruitment, ratio, maxF)
}
\arguments{
\item{recruitment}{2-column matrix with recruitment parameters. First column gives the lengths of each period of recruitment. Second column gives the corresponding rates of recruitment for each period.}

\item{ratio}{Randomisation ratio; active arm divided by control arm.}

\item{maxF}{Fixed follow-up time per patient, i.e. maximum time a patient will be at risk independent of length of study.}
}
\description{
This creates a RCurve object for a piecewise-linear recruitment distribution with a fixed (maximum) per-patient follow-up time.\cr
RCurve objects contain all necessary information to describe a recruitment distribution. They are a particular type of Curve object containing additional recruitment-related information, including patient numbers and the randomisation ratio.\cr
}
\details{
This RCurve is used when it is expected that patients enter a trial at a rate that varies over time and there is a fixed maximum follow-up time per patient.
}
\examples{
rmatrix <- matrix(c(rep(4,3),5,10,15),ncol=2)
rmatrix
PieceRMaxF(recruitment=rmatrix,ratio=1,maxF=12)
}
\author{
James Bell
}
