% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.getDTeval.R
\name{benchmark.getDTeval}
\alias{benchmark.getDTeval}
\title{benchmark.getDTeval}
\usage{
benchmark.getDTeval(
  the.statement,
  times = 30,
  seed = 47,
  envir = .GlobalEnv,
  ...
)
}
\arguments{
\item{the.statement}{refers to the original coding statement which needs to be translated to an optimized form.  This value may be entered as either a character value or as an expression.}

\item{times}{The number of iterations to run the benchmarking experiment}

\item{seed}{an integer value specifying the seed of the pseudorandom number generator.}

\item{envir}{The environment in which the calculation takes place, with the global environment .GlobalEnv set as the default.}

\item{...}{provision for additonal arguments}
}
\description{
Performs a benchmarking experiment for data.table coding statements that use get() or eval() for programmatic designs.  The a) original statement is compared to b) passing the original statement through getDTeval and also to c) an optimized coding statement.  The results can demonstrate the overall improvement of using the coding translations offered by getDTeval()
}
\examples{
#Benchmarking runtime performances in calculating mean age
dat<-formulaic::snack.dat
age.name<-'Age'
benchmark.getDTeval(the.statement = "dat[,.(mean_age=mean(get(age.name)))]", times = 5,  seed = 10)
}
