% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot_quantreg_noisy}
\alias{plot_quantreg_noisy}
\title{Linear Programming - Function for plotting results of sparse quantile regression}
\usage{
plot_quantreg_noisy(y, X, taus = c(0.05, 0.25, 0.5, 0.75, 0.95),
  lambdas = c(0, 0.5, 1, 1.5))
}
\arguments{
\item{y}{Response variable}

\item{X}{Noisy matrix (includes x)}

\item{taus}{(optional) Quantiles for plotting, default is 'c(0.05,0.25,0.5,0.75,0.95)'}

\item{lambdas}{(optional) Regularization parameters (Default is lambdas=c(0,0.5,1,1.5).)}
}
\description{
\code{plot_noisyquantreg} Function for plotting results of bivariate quantile regression with noise.
}
\examples{
data <- generate_sparse_data(n=100,p=20,k=3)
y <- data$y
X <- data$X

lambdas=c(0,1,5,7)
plot_quantreg_noisy(y,X,lambdas=lambdas) # Not run
}
\author{
Jocelyn T. Chi
}

