% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggDNAvis-package.R
\docType{data}
\name{fastq_quality_scores}
\alias{fastq_quality_scores}
\title{Vector of the quality scores used by the FASTQ format}
\format{
\subsection{\code{fastq_quality_scores}}{

A character vector of length 41
\describe{
\item{fastq_quality_scores}{The vector \code{c("!", '"', "#", "$", "\%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I")}}
}
}
}
\usage{
fastq_quality_scores
}
\description{
A vector of the characters used to indicate quality scores from 0 to 40
in the FASTQ format. These scores are related to the error probability \eqn{p}
via \eqn{Q = -10 \text{ log}_{10}(p)}, so a Q-score of 10 (represented by \code{"+"}) means
the error probability is 0.1, a Q-score of 20 (\code{"5"}) means the error probability
is 0.01, and a Q-score of 30 (\code{"?"}) means the error probability is 0.001.\cr\cr
The character representations store Q-scores in one byte each by using ASCII encodings,
where the Q-score for a character is its ASCII code minus 33 (e.g. \code{A} has an ASCII
code of 65 and represents a Q-score of 32).\cr\cr
This vector contains the characters in order but starting with a score of 0, meaning
the character at index \eqn{n} represents a Q-score of \eqn{n-1} e.g. the first
character (\code{"!"}) represents a score of 0; the eleventh character (\code{"+"})
represents a score of 10.\cr\cr
The full set of possible score representations, in order and presented as a single
string, is \verb{!"#$\%&'()*+,-./0123456789:;<=>?@ABCDEFGHI}.\cr\cr
Generation code is available at \code{data-raw/fastq_quality_scores.R}
}
\keyword{datasets}
