% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-eta-cov.R
\name{eta_cov}
\alias{eta_cov}
\title{This creates an ETA covariance matrix which can be used to define the co-relation between the parameters and
its shrinkage..}
\usage{
eta_cov(
  labels,
  type = c("cats", "conts"),
  dname = NULL,
  show.correl = TRUE,
  correl = NULL,
  facets = NULL,
  point = NULL,
  covariates = NULL,
  is.strat.color = FALSE,
  ...
)
}
\arguments{
\item{labels}{list of texts/titles used within the plot}

\item{type}{box for cats or conts}

\item{dname}{name of dataset to be used}

\item{show.correl}{\code{logical} if TRUE add correlation to the plot}

\item{correl}{\code{list} correl geom text graphical parameter}

\item{facets}{\code{list} facetting graphical parameter}

\item{point}{\code{list} geom point graphical parameter}

\item{covariates}{\code{pmxCOVObject} \code{\link{pmx_cov}}}

\item{is.strat.color}{\code{logical} if `TRUE` use a different color for the spline stratification.}

\item{...}{others graphics arguments passed to \code{\link{pmx_gpar}} internal object.}
}
\value{
\code{eta_cov} object
}
\description{
This creates an ETA covariance matrix which can be used to define the co-relation between the parameters and
its shrinkage..
}
\details{
\strong{labels} is a list that contains:
\itemize{
\item \strong{title:} plot title default  "EBE vs. covariates"
\item \strong{x:} x axis label default to "Etas"
\item \strong{y:} y axis label default to empty
}
}
\seealso{
Other plot_pmx: 
\code{\link{distrib}()},
\code{\link{eta_pairs}()},
\code{\link{individual}()},
\code{\link{plot_pmx.distrib}()},
\code{\link{plot_pmx.eta_cov}()},
\code{\link{plot_pmx.eta_pairs}()},
\code{\link{plot_pmx.individual}()},
\code{\link{plot_pmx.pmx_dens}()},
\code{\link{plot_pmx.pmx_gpar}()},
\code{\link{plot_pmx.pmx_qq}()},
\code{\link{plot_pmx.residual}()},
\code{\link{plot_pmx}()}
}
\concept{plot_pmx}
