% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_QC_FUNs.R
\name{xBar_sBar_UCL}
\alias{xBar_sBar_UCL}
\title{Mean of Subgroup Means Upper Control Limit (UCL) based on Standard Deviation}
\usage{
xBar_sBar_UCL(data, value, grouping, n = NULL, natural = F,
  formula = NULL)
}
\arguments{
\item{data}{data frame to be processed}

\item{value}{numeric vector in a data frame with values of interest.}

\item{grouping}{single factor/variable to split the data frame "values" by.}

\item{n}{a number indicating a hypothetical subgroup size other than, function determined subgroup n
determined by the floor length of subgroup values.}

\item{natural}{logical, if TRUE calculate limits for individuals (n=1) else calculate for
n determined by the floor length of subgroup values}

\item{formula}{a formula, such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}
}
\value{
A number; mean of subgroup means Upper Control Limit (UCL) based on standard deviation
}
\description{
Calculates the mean of subgroup means upper control limit based on the
standard deviation. The result is used when constructing a xBar-S charts.
}
\examples{
set.seed(5555)
df <- data.frame(v=rnorm(60, 0, 1), g=rep(c("A","B","C","D","E"), each=12))
xBar_sBar_UCL(data = df, formula = v~g)
}
