% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_Summay__Capability_FUNs.R
\name{QC_Capability}
\alias{QC_Capability}
\title{Calculate Summary of Quality Performance Parameters}
\usage{
QC_Capability(data = NULL, value = NULL, grouping = NULL,
  formula = NULL, method = "xBar.rBar", na.rm = FALSE, LSL = NULL,
  USL = NULL, digits = 2)
}
\arguments{
\item{data}{vector or dataframe, as indicated below for each chart type
\itemize{
\item \bold{Individuals (XmR)}: vector of values;
\item \bold{Studentized}: dataframe
}}

\item{value}{string, \bold{Studentized Charts}, name of numeric vector in dataframe with values of interest.}

\item{grouping}{string, \bold{Studentized Charts}, name of single factor/variable to split
the dataframe "values" by}

\item{formula}{\bold{Studentized Charts}: a formula,
such as y ~ x1 + x2, where the y variable is
numeric data to be split into groups according to the grouping x
factors/variables}

\item{method}{string, calling one of the following methods:
\itemize{
\item \bold{Individuals Charts}: XmR,
\item \bold{Studentized Charts}: xBar.rBar, xBar.rMedian, xBar.sBar, xMedian.rBar
}}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{LSL}{numeric, Customer's lower specification limit}

\item{USL}{numeric, Customer's Upper specification limit
\itemize{
\item \bold{Proc. Tolerance (sigma)}: Describes the number of your process sigma (from QC charting) that can fit in your customer's specification window (the larger the better).
\item \bold{DNS (sigma)}: Distance to Nearest Specification (DNS) limit. Measure of how centered your process is and how close you are to the nearest process limit in sigma units.
\item \bold{Cp}: Describes how many times your 6 sigma process window (from QC charting) can fit in your customer's specification window (the larger the better)
\item \bold{Cpk}: Describes how centered your process is relative to customer specifications. How many times can you fit a 3 sigma window (from QC charting) between your process center and the nearest customer specification limit.
\item \bold{Pp}: Describes how many times your 6 sigma process window (overall standard deviation) can fit in your customer's specification window (the larger the better)
\item \bold{Ppk}: Describes how centered your process is relative to customer specifications. How many times can you fit a 3 sigma window (overall standard deviation) between your process center and the nearest customer specification limit.
}}

\item{digits}{integer, how many digits to report.}
}
\value{
data frame , listing of metric labels and value
}
\description{
function to report listing of quality performance parameters
}
