% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-quad-upset.R
\name{ggupset}
\alias{ggupset}
\title{Create an UpSet plot}
\usage{
ggupset(
  data = NULL,
  mapping = aes(),
  ...,
  direction = "h",
  point = NULL,
  line = NULL,
  rect = NULL,
  width = NA,
  height = NA,
  theme = NULL,
  active = NULL
)
}
\arguments{
\item{data}{Data used to create the UpSet plot. \code{\link[=fortify_matrix]{fortify_matrix()}} will be
used to convert the data to a matrix. Currently, only
\code{\link{fortify_matrix.list_upset}} and \code{\link{fortify_matrix.matrix_upset}} are
suitable for creating an UpSet plot.}

\item{mapping}{Default list of aesthetic mappings to use for main plot in the
layout. If not specified, must be supplied in each layer added to the main
plot.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{direction}{A string indicating the direction of the UpSet plot,
\code{"h"}(\code{horizontal}) or \code{"v"}(\code{vertical}). In a vertical UpSet plot, the
columns of the matrix correspond to the sets, and the rows correspond to the
intersections. By default, the horizontal UpSet plot is used, where the rows
of the matrix correspond to the sets and the columns correspond to the
intersections.}

\item{point}{A list of parameters passed to
\code{\link[ggplot2:geom_point]{geom_point()}}.}

\item{line}{A list of parameters passed to
\code{\link[ggplot2:geom_path]{geom_line()}}.}

\item{rect}{A list of parameters passed to
\code{\link[ggplot2:geom_tile]{geom_rect()}}.}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} object used to customize various
elements of the layout, including \code{guides}, \code{title}, \code{subtitle}, \code{caption},
\code{margins}, \code{panel.border}, and \code{background}. By default, the theme will
inherit from the parent \code{layout}. It also controls the panel spacing for all
plots in the layout.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{ggupset} is a specialized version of \code{\link[=quad_discrete]{quad_discrete()}}, which simplifies
the creation of Upset plot.
}
\section{ggplot2 specification}{

The data input will be converted to a matrix using \code{\link[=fortify_matrix]{fortify_matrix()}}, and
the data in the underlying main plot will contain the following columns:
\itemize{
\item \code{.panel_x} and \code{.panel_y}: the column and row panel groups.
\item \code{.x} and \code{.y}: an integer index of \code{x} and \code{y} coordinates
\item \code{.discrete_x} and \code{.discrete_y}: a factor of the data labels (only
applicable when \code{.row_names} and \code{.column_names} exists).
\item \code{.row_names} and \code{.column_names}: A character of the row and column names
of the original matrix (only applicable when names exist).
\item \code{.row_index} and \code{.column_index}: the row and column index of the original
matrix.
\item \code{value}: the actual matrix value.
}
}

\examples{
set.seed(123)
lt <- list(
    a = sample(letters, 5),
    b = sample(letters, 10),
    c = sample(letters, 15)
)
ggupset(tune(lt)) +
    scale_fill_manual(values = c("#F0F0F0", "white"), guide = "none") +
    scale_color_manual(values = c("grey", "black"), guide = "none") +
    anno_top() +
    ggalign(data = function(d) ggalign_attr(d, "intersection_sizes")) +
    ggplot2::geom_bar(aes(y = .data$value), stat = "identity") +
    anno_right() +
    ggalign(data = function(d) ggalign_attr(d, "set_sizes")) +
    ggplot2::geom_bar(aes(x = .data$value),
        stat = "identity",
        orientation = "y"
    )
}
