% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-order.R
\name{layer_order}
\alias{layer_order}
\title{Change the layer adding order}
\usage{
layer_order(layer, order = 0)
}
\arguments{
\item{layer}{A \code{\link[ggplot2:layer_geoms]{layer geometry}} object to be added.}

\item{order}{An integer indicating the position at which the layer should be
added. If \verb{<= 0}, the layer will be added at the beginning. If greater than
the number of plot layers, it will be added at the end.}
}
\value{
A \code{layer_order} object.
}
\description{
This function allows you to change the order in which layers are added to a
ggplot.
}
\examples{
ggplot(faithfuld, aes(waiting, eruptions)) +
    geom_raster(aes(fill = density)) +
    geom_point(color = "red", size = 1)
ggplot(faithfuld, aes(waiting, eruptions)) +
    geom_raster(aes(fill = density)) +
    layer_order(geom_point(color = "red", size = 1))
}
