% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_blanket.R
\name{set_blanket}
\alias{set_blanket}
\title{Set the default style}
\usage{
set_blanket(
  mode = light_mode_r(),
  geom_default_colour = blue,
  annotate_default_colour = lightness[2],
  ...
)
}
\arguments{
\item{mode}{A \verb{*_mode_*} theme set globally for when mode = NULL. E.g. \code{\link[=light_mode_t]{light_mode_t()}}, \code{\link[=grey_mode_r]{grey_mode_r()}}, or \code{\link[=dark_mode_r]{dark_mode_r()}}.}

\item{geom_default_colour}{A default geom colour used within \code{weave_geom_defaults()}.}

\item{annotate_default_colour}{A default annotate colour used within \code{weave_annotate_defaults()}.}

\item{...}{Provided only to support trailing commas.}
}
\value{
A globally set mode and updated geom defaults.
}
\description{
Set the default style by setting the default mode and updating a series of geom and annotate defaults.
}
\examples{
library(ggplot2)
library(ggblanket)
library(palmerpenguins)

set_blanket(dark_mode_r(), orange, darkness[2])

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    x_breaks = scales::breaks_pretty(3),
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.25), y = I(0.75), label = "Here")

penguins |>
  gg_histogram(
    x = flipper_length_mm,
    x_breaks = scales::breaks_pretty(3),
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.75), y = I(0.75), label = "Here")

set_blanket()

}
