% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{scale_adjusted}
\alias{scale_adjusted}
\alias{scale_dag}
\title{Common scale adjustments for DAGs}
\usage{
scale_adjusted()

scale_dag(breaks = ggplot2::waiver())
}
\arguments{
\item{breaks}{One of:
\itemize{
\item NULL for no breaks
\item waiver() for the default breaks computed by the transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks as output
}}
}
\description{
\code{scale_adjusted()} is a convenience function that implements ways of
visualizing adjustment for a variable. By convention, a square shape is used
to indicate adjustment and a circle when not adjusted. Arrows out of adjusted
variables are often eliminated or de-emphasized, and \code{scale_adjusted()} uses
a lower \code{alpha} for these arrows. When adjusting a collider, a dashed line is
sometimes used to demarcate opened pathways, and \code{scale_adjusted()} does this
whenever \code{\link[=geom_dag_collider_edges]{geom_dag_collider_edges()}} is used. \code{scale_dag()} is deprecated in
favor of \code{scale_adjusted()}.
}
