% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdmc_eam.R
\name{transform}
\alias{transform}
\alias{transform.norm}
\alias{transform.rd}
\title{Transform Parameter Data Frame}
\usage{
transform(mdi, par.df, ...)

\method{transform}{rd}(mdi, par.df, ...)

\method{transform}{norm}(mdi, par.df, ...)
}
\arguments{
\item{mdi}{a model data instance}

\item{par.df}{a data frame}

\item{...}{other arguments}
}
\description{
Transforms parameters to a form suitbale for the model been used
The function is called inside of \code{get.par.mat}.
\code{par.df} is a data frame of parameters types, some of which may need
to be transformed, or new columns created, so that the full set of
internal parameter types, specified in \code{type.par.names} attribute in
a model data instance, required by the type of evidence accumulation model
being used, such as the \code{norm} class in one of the LBA models, is
present.
}
\details{
\code{transform.norm} template sets up for n-choice LBA, \eqn{B=b-A}
parameterization.

External parameters types: \code{A}, \code{B}, \code{t0}, \code{mean_v},
\code{sd_v}, \eqn{st0 = 0} (optional).
Internal parameters types: \code{A}, \code{b}, \code{t0}, \code{mean_v},
\code{sd_v}, \eqn{st0 = 0} (optional).
}
\keyword{transform}

