% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{profile.model}
\alias{profile.model}
\title{Profile a model object}
\usage{
\method{profile}{model}(fitted, pname, minp, maxp, p.vector,
  npoint = 100, digits = 2, ylim = NA, nthread = 32, ...)
}
\arguments{
\item{fitted}{a data model instance}

\item{pname}{indicate which parameter in theta to plot. For example, in a
LBA model with a \code{pVec <- c(A="1",B="1",mean_v="M",sd_v="1",t0="1",
st0="1")}, one can assign \code{pname <- "A"} to ask \code{profile} to
profile \emph{A} parameter}

\item{minp}{lower bound for pname parameter}

\item{maxp}{upper bound for pname parameter}

\item{p.vector}{a parameter vector. Use Lognromal LBA model as an example,
\code{pVec <- c(A = .25, B = .35, meanlog_v.true = 1, meanlog_v.false = .25,
sdlog_v.true = .5, t0 = .2)}}

\item{npoint}{grid for p.name parameter}

\item{digits}{print out how many digits}

\item{ylim}{y range}

\item{nthread}{number of thread in a GPU block. This argument works for
GPU-based PDA probability density functions)}

\item{...}{additional optional arguments.}
}
\description{
This function produces data for profiling model likelihoods based on a data
model instance (ie \code{fitted}).
}
\details{
The argument, \code{pname} indicates which model parameter to profile.
For example, if we want to profile the boundary separation \emph{a} in a
DDM, we extract it from a \code{p.vector} and calculates its marginal
likelihoods based on the data model instance on a grid of \code{n.point}.

Briefly, the function sets a range for the points on the x axis, which
is the values for the profiled parameter (e.g., \emph{a}). Then it
initiates a log-likelihodd vector with length of \code{n.point} and 0
everywhere.  Next, it keeps the other parameters in the model fixed and
changes only the target parameter values to ps[i]. After that, it
calculates their sum log-likelihoods. Finally, it stores the
log-likelihoods in the \code{i} position of the ll vector.
}
\examples{
model <- BuildModel(
        p.map     = list(a = "1",v = "1",z = "1", d = "1", sz = "1",
                    sv = "1", t0 = "1", st0 = "1"),
        constants = c(st0 = 0, d = 0),
        match.map = list(M = list(s1 = "r1", s2 = "r2")),
        factors   = list(S = c("s1", "s2")),
        responses = c("r1", "r2"),
        type      = "rd")

p.prior <- BuildPrior(
  dists = rep("tnorm", 6),
  p1=c(a=2,   v=2.5, z=0.5, sz=0.3, sv=1,  t0=0.3),
  p2=c(a=0.5, v=.5,  z=0.1, sz=0.1, sv=.3, t0=0.05),
  lower=c(0,-5, 0, 0, 0, 0),
  upper=c(5, 7, 2, 2, 2, 2))

p.vector <- c(a=1,v=1, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat <- simulate(model, 1e2, ps = p.vector)
dmi <- BuildDMI(dat, model)

## ------------------------------40
par(mfrow=c(2,3));
profile(dmi, "a",  .1,   2, p.vector)
profile(dmi, "v",  .1,   2, p.vector)
profile(dmi, "z",  .2,  .8, p.vector)
profile(dmi, "sz", .1,  .9, p.vector)
profile(dmi, "sv", .1,   2, p.vector)
profile(dmi, "t0", .01, .5, p.vector)
par(mfrow=c(1,1));
}
