% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridlines.R
\name{easy_remove_gridlines}
\alias{easy_remove_gridlines}
\alias{easy_remove_x_gridlines}
\alias{easy_remove_y_gridlines}
\title{Easily remove gridlines}
\usage{
easy_remove_gridlines(
  axis = c("both", "x", "y"),
  minor = TRUE,
  major = TRUE,
  teach = FALSE
)

easy_remove_x_gridlines(minor = TRUE, major = TRUE, teach = FALSE)

easy_remove_y_gridlines(minor = TRUE, major = TRUE, teach = FALSE)
}
\arguments{
\item{axis}{From which axis should grid lines be removed? By default \code{"both"}.}

\item{minor}{Should minor grid lines be removed? By default \code{TRUE}.}

\item{major}{Should major grid lines be removed? By default \code{TRUE}.}

\item{teach}{Should the equivalent \code{ggplot2} expression be printed? By
default \code{FALSE}.}
}
\value{
a \code{\link[ggplot2]{theme}} object which can be used in
\code{\link[ggplot2]{ggplot2}} calls
}
\description{
Easily remove any gridlines from a \code{ggplot}.
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(hp, mpg))

# remove all grid lines at once
p + easy_remove_gridlines()

# remove all minor grid lines
p + easy_remove_gridlines(major = FALSE)

# remove all major grid lines
p + easy_remove_gridlines(minor = FALSE)

# remove x gridlines
p + easy_remove_x_gridlines()
# or
p + easy_remove_gridlines(axis = "x")

# remove y gridlines
p + easy_remove_y_gridlines()

}
\author{
Thomas Neitmann
}
