% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggca}
\alias{ggca}
\title{Readable and Interactive graph for simple correspondence analysis}
\usage{
ggca(
  res.ca = res.ca,
  axes = c(1, 2),
  show_sup = FALSE,
  xlim,
  ylim,
  out_lims_move = FALSE,
  type = c("points", "text", "labels"),
  text_repel = FALSE,
  uppercase = "col",
  tooltips = c("row", "col"),
  rowtips_subtitle = "Row pct",
  coltips_subtitle = "Column pct",
  rowcolor_numbers = 0,
  colcolor_numbers = 0,
  cleannames = TRUE,
  filter = "",
  title,
  text_size = 3.5,
  dist_labels = c("auto", 0.12),
  right_margin = 0,
  size_scale_max = 8,
  use_theme = TRUE
)
}
\arguments{
\item{res.ca}{An object created with \code{FactoMineR::\link[FactoMineR]{CA}}.}

\item{axes}{The axes to print, as a numeric vector of length 2.}

\item{show_sup}{When \code{TRUE} show supplementary rows and cols.}

\item{xlim, ylim}{Horizontal and vertical axes limits,
as double vectors of length 2.}

\item{out_lims_move}{When \code{TRUE}, the points out of \code{xlim} or
\code{ylim} are not removed, but moved at the edges of the graph.}

\item{type}{Determines the way the two variables of the table are printed.
  \itemize{
  \item \code{"points"} : colored points with text legends
  \item \code{"text"} : colored text
  \item \code{"labels"} : colored labels
}}

\item{text_repel}{When \code{TRUE} the graph is not interactive anymore,
but the resulting image is better to print because points and labels don't
overlaps. It uses \code{ggrepel::\link[ggrepel]{geom_text_repel}}.}

\item{uppercase}{Print \code{"row"} var or \code{"col"} var labels with
uppercase.}

\item{tooltips}{Choose the content of interactive tooltips at mouse hover :
\code{"col"} for the table of columns percentages, \code{"row"} for line
percentages, default to \code{c("row", "col")} for both.}

\item{rowtips_subtitle, coltips_subtitle}{The subtitles used before the table
in interactive tooltips.}

\item{rowcolor_numbers, colcolor_numbers}{If row var or col var levels are
prefixed with numbers(ex. : \code{"1-"} ), the number of digits to use
to create classes that will be used to add colors to points.}

\item{cleannames}{Set to \code{TRUE} to clean levels names, by removing
prefix numbers like \code{"1-"}, and text in parentheses.}

\item{filter}{Regex patterns to discard levels of row or col variables.}

\item{title}{The title of the graph.}

\item{text_size}{Size of text.}

\item{dist_labels}{When \code{type = "points"}, the distance of text and
labels from points.}

\item{right_margin}{A margin at the right, in cm. Useful to read tooltips
over points placed at the right of the graph without formatting problems.}

\item{size_scale_max}{Size of points.}

\item{use_theme}{By default, a specific \code{ggplot2} theme is used.
Set to \code{FALSE} to customize your own \code{\link[ggplot2:theme]{theme}}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object to be printed in the
`RStudio` Plots pane. Possibility to add other gg objects with \code{+}.
Sending the result  through \code{\link{ggi}} will draw the
interactive graph in the Viewer pane using \code{\link[ggiraph]{ggiraph}}.
}
\description{
A readable, complete and beautiful graph for simple
correspondence analysis made with \code{FactoMineR::\link[FactoMineR]{CA}}.
Interactive tooltips, appearing when hovering on  points with mouse, allow to
keep in mind all the content of the table while reading the graph. Since it is
made in the spirit of \code{\link[ggplot2]{ggplot2}}, it is possible to change
theme or add another plot elements with +. Then, interactive
tooltips won't appear until you pass the result through \code{\link{ggi}}.
}
\examples{
# Make the correspondence analysis :
\donttest{
tabs <- table(forcats::gss_cat$race, forcats::gss_cat$marital)[-4,]
# tabs <- tabxplor::tab_plain(forcats::gss_cat, race, marital, df = TRUE)
res.ca <- FactoMineR::CA(tabs, graph = FALSE)

# Interactive plot :
graph.ca <- ggca(res.ca,
                 title = "Race by marital : correspondence analysis",
                 tooltips = c("row", "col"))
ggi(graph.ca) #to make the plot interactive

# Image plot :
ggca(res.ca,
     title = "Race by marical : correspondence analysis",
     text_repel = TRUE)
     }
}
