% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometrical_data_analysis.R
\name{ggpca_3d}
\alias{ggpca_3d}
\title{Interactive 3D Plot for Principal Component Analyses (plotly::)}
\usage{
ggpca_3d(
  res.pca,
  axes = c(1, 2, 3),
  princ_axes_print = -3:3,
  base_axe_n_breaks = 10,
  ind.size = 4,
  ind_name.size = 3,
  title,
  center = TRUE,
  var_names_on = "var",
  base_zoom = 1,
  remove_buttons = FALSE,
  cone_size = 0.33,
  view = "All",
  type = c("var", "ind", "main_plan", "projections"),
  camera_view,
  aspectratio_from_eig = FALSE,
  always_make_ind_tooltips = FALSE,
  var_color = "#4D4D4D",
  max_ind = 500,
  max_ind_seed
)
}
\arguments{
\item{res.pca}{The result of \code{\link[FactoMineR:PCA]{FactoMineR::PCA}}.}

\item{axes}{The axes to print, as a numeric vector of length 3 (or 2).}

\item{princ_axes_print}{The breaks of the principal axes.}

\item{base_axe_n_breaks}{The number of breaks in initial variables axes.}

\item{ind.size}{The size of the points of individuals.}

\item{ind_name.size}{The size of the names of individuals.}

\item{title}{Plot title.}

\item{center}{By default the plot is centered on the central point. Set to
`FALSE` to center on the origin of all variables (zero coordinates).}

\item{var_names_on}{By default `"var"` the names of variables are drawn upon
the initial axes. Set to `"cor"` to draw them upon correlation vectors instead.}

\item{base_zoom}{The base level of zoom.}

\item{remove_buttons}{Set to TRUE to remove buttons to change view.}

\item{cone_size}{The size of the conic arrow at the end of each axe.}

\item{view}{The starting point of view (in 3D) :
    \itemize{
  \item \code{"Plane 1-2"} : Axes 1 and 2.
  \item \code{"Plane 1-3"} : Axes 1 and 3.
  \item \code{"Plane 2-3"} : Axes 2 and 3.
  \item \code{"All"      } : A 3D perspective with Axes 1, 2, 3.
}}

\item{type}{Which elements of the graph to print, among :
#'      \itemize{
   \item \code{"var"        } : initial variables axes, with breaks
   \item \code{"cor"        } : normalized correlation vectors (length = 1)
   \item \code{"cor_sphere" } : a 3D sphere of standard deviation 1
   \item \code{"ind"        } : points of individuals
   \item \code{"ind_name"   } : names of individuals
   \item \code{"main_plan"  } : the plan 1-2.
   \item \code{"projections"} : projections of mean point on initial variables
   \item \code{"V"          } : vectors of the V transition matrix
   \item \code{"vs"         } : vectors of the matrix of singular values
 }}

\item{camera_view}{Possibility to add a (replace `view`)}

\item{aspectratio_from_eig}{Set to `TRUE` to modify axes length based on
eigenvalues.}

\item{always_make_ind_tooltips}{Set to `TRUE` to add interactive toolips for
individuals.}

\item{var_color}{The color of the initial variables/dimensions}

\item{max_ind}{The maximun number of individuals to print.}

\item{max_ind_seed}{The random seed used to sample individuals.}
}
\value{
A \code{\link[plotly]{plotly}} html interactive 2d or 3d graph.
}
\description{
Interactive 3D Plot for Principal Component Analyses (plotly::)
}
\examples{
\donttest{
data(mtcars, package = "datasets")
mtcars <- mtcars[1:7] |> dplyr::rename(weight = wt)
res.pca <- FactoMineR::PCA(mtcars, graph = FALSE)

# Variables and individuals
ggpca_3d(res.pca)

# Circle of correlation 3D
ggpca_3d(res.pca, type = c("cor", "cor_sphere"),
         var_names_on = "cor", base_zoom = 0.6,
         princ_axes_print = -1:1, view = "All"
)
}
}
