% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier.R
\name{geom_bezier}
\alias{geom_bezier}
\alias{stat_bezier}
\alias{stat_bezier2}
\alias{geom_bezier2}
\alias{stat_bezier0}
\alias{geom_bezier0}
\title{Create quadratic or cubic bezier curves}
\usage{
stat_bezier(mapping = NULL, data = NULL, geom = "path",
  position = "identity", na.rm = FALSE, show.legend = NA, n = 100,
  inherit.aes = TRUE, ...)

geom_bezier(mapping = NULL, data = NULL, stat = "bezier",
  position = "identity", arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, n = 100,
  ...)

stat_bezier2(mapping = NULL, data = NULL, geom = "path_interpolate",
  position = "identity", na.rm = FALSE, show.legend = NA, n = 100,
  inherit.aes = TRUE, ...)

geom_bezier2(mapping = NULL, data = NULL, stat = "bezier2",
  position = "identity", arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, n = 100,
  ...)

stat_bezier0(mapping = NULL, data = NULL, geom = "bezier0",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

geom_bezier0(mapping = NULL, data = NULL, stat = "bezier0",
  position = "identity", arrow = NULL, lineend = "butt",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{n}{The number of points to create for each segment}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{lineend}{Line end style (round, butt, square).}
}
\description{
This set of geoms makes it possible to connect points creating either
quadratic or cubic beziers. bezier and bezier2 both work by calculating
points along the bezier and connecting these to draw the curve. bezier0
directly draws the bezier using bezierGrob. In line with the \code{\link[=geom_link]{geom_link()}} and
\code{\link[=geom_link2]{geom_link2()}} differences geom_bezier creates the points, assign
an index to each interpolated point and repeat the aesthetics for the start
point, while geom_bezier2 interpolates the aesthetics between the start and
end points.
}
\details{
Input data is understood as a sequence of data points the first being the
start point, then followed by one or two control points and then the end
point. More than 4 and less than 3 points per group will throw an error.
\code{\link[grid:bezierGrob]{grid::bezierGrob()}} only takes cubic beziers so if three points are
supplied the middle one as duplicated. This, along with the fact that
\code{\link[grid:bezierGrob]{grid::bezierGrob()}} estimates the curve using an x-spline means
that the curves produced by geom_bezier and geom_bezier2 deviates from those
produced by geom_bezier0. If you want true bezier paths use geom_bezier or
geom_bezier2.
}
\section{Aesthetics}{

geom_bezier, geom_bezier2 and geom_bezier0 understand the following aesthetics
(required aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{y}
\item color
\item size
\item linetype
\item alpha
\item lineend
}
}

\section{Computed variables}{


\describe{
\item{x, y}{The interpolated point coordinates}
\item{index}{The progression along the interpolation mapped between 0 and 1}
}
}

\examples{
beziers <- data.frame(
  x = c(1, 2, 3, 4, 4, 6, 6),
  y = c(0, 2, 0, 0, 2, 2, 0),
  type = rep(c('cubic', 'quadratic'), c(3, 4)),
  point = c('end', 'control', 'end', 'end', 'control', 'control', 'end'),
  colour = letters[1:7]
)
help_lines <- data.frame(
  x = c(1, 3, 4, 6),
  xend = c(2, 2, 4, 6),
  y = 0,
  yend = 2
)

# See how control points affect the bezier
ggplot() +
  geom_segment(aes(x = x, xend = xend, y = y, yend = yend),
               data = help_lines,
               arrow = arrow(length = unit(c(0, 0, 0.5, 0.5), 'cm')),
               colour = 'grey') +
  geom_bezier(aes(x = x, y = y, group = type, linetype = type),
              data = beziers) +
  geom_point(aes(x = x, y = y, colour = point),
             data = beziers)

# geom_bezier0 is less exact
ggplot() +
  geom_segment(aes(x = x, xend = xend, y = y, yend = yend),
               data = help_lines,
               arrow = arrow(length = unit(c(0, 0, 0.5, 0.5), 'cm')),
               colour = 'grey') +
  geom_bezier0(aes(x = x, y = y, group = type, linetype = type),
               data = beziers) +
  geom_point(aes(x = x, y = y, colour = point),
             data = beziers)

# Use geom_bezier2 to interpolate between endpoint aesthetics
ggplot(beziers) +
  geom_bezier2(aes(x = x, y = y, group = type, colour = colour))

}
