% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newplots.R
\name{gf_ash}
\alias{gf_ash}
\alias{stat_ash}
\alias{geom_ash}
\title{Average Shifted Histograms}
\usage{
gf_ash(
  object = NULL,
  gformula = NULL,
  data = NULL,
  ...,
  alpha,
  color,
  group,
  linetype,
  size,
  xlab,
  ylab,
  title,
  subtitle,
  caption,
  geom = "line",
  stat = "ash",
  position = "identity",
  show.legend = NA,
  show.help = NULL,
  inherit = TRUE,
  environment = parent.frame()
)

stat_ash(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  binwidth = NULL,
  adjust = 1,
  ...
)

geom_ash(
  mapping = NULL,
  data = NULL,
  stat = "ash",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  binwidth = NULL,
  adjust = 1,
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{~x} or \code{y ~ x}.
\code{y} may be \code{stat(density)} or \code{stat(count)} or \code{stat(ndensity)} or \code{stat(ncount)}.
Faceting can be achieved by including \code{|} in the formula.}

\item{data}{A data frame with the variables to be plotted.}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}

\item{color}{A color or a formula used for mapping color.}

\item{group}{Used for grouping.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{size}{A numeric size or a formula used for mapping size.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{A character string naming the geom used to make the layer.}

\item{stat}{A character string naming the stat used to make the layer.}

\item{position}{Either a character string naming the position function used
for the layer or a position object returned from a call to a position function.}

\item{show.legend}{A logical indicating whether this layer should be included in
the legends.  \code{NA}, the default, includes layer in the legends if any
of the attributes of the layer are mapped.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{mapping}{set of aesthetic mappings created by \code{\link[=aes]{aes()}}
or \code{\link[=aes_]{aes_()}}.}

\item{na.rm}{If FALSE (the default), removes missing values with a warning.
If TRUE silently removes missing values.}

\item{inherit.aes}{A logical indicating whether default aesthetics are inherited.}

\item{binwidth}{the width of the histogram bins.  If \code{NULL} (the default) the
binwidth will be chosen so that approximately 10 bins cover the data.  \code{adjust}
can be used to to increase or decrease \code{binwidth}.}

\item{adjust}{a numeric adjustment to \code{binwidth}.  Primarily useful when \code{binwidth} is
not specified.  Increasing \code{adjust} makes the plot smoother.}
}
\value{
a gg object
}
\description{
An ASH plot is the average over all histograms of a fixed bin width.
\code{geom_ash()} and \code{gf_ash()} provide ways to create ASH plots
using \pkg{ggplot2} or \pkg{ggformula}.
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
gf_ash(~Sepal.Length, color = ~Species, data = iris)
gf_ash(~Sepal.Length, color = ~Species, data = iris, binwidth = 0.3)
gf_ash(~Sepal.Length, color = ~Species, data = iris, adjust = 2)
ggplot(faithful, aes(x = eruptions)) +
  geom_histogram(aes(y = stat(density)),
    fill = "lightskyblue", colour = "gray50", alpha = 0.2
  ) +
  geom_ash(colour = "red") +
  geom_ash(colour = "forestgreen", adjust = 2) +
  geom_ash(colour = "navy", adjust = 1 / 2) +
  theme_minimal()
}
\seealso{
\code{\link[=geom_histogram]{geom_histogram()}}, \code{link{gf_histogram}()}.
}
