% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_glmnet.R
\name{autoplot.cv.glmnet}
\alias{autoplot.cv.glmnet}
\title{Autoplot \code{glmnet::cv.glmnet}}
\usage{
\method{autoplot}{cv.glmnet}(object, sign.lambda = 1, label.n = 12,
  label = TRUE, label.label = "nz", label.colour = NULL,
  label.alpha = NULL, label.size = NULL, label.angle = NULL,
  label.family = NULL, label.fontface = NULL, label.lineheight = NULL,
  label.hjust = NULL, label.vjust = NULL, label.repel = FALSE,
  xlim = c(NA, NA), ylim = c(NA, NA), log = "", main = NULL,
  xlab = NULL, ylab = NULL, asp = NULL, ...)
}
\arguments{
\item{object}{\code{glmnet::cv.glmnet} instance}

\item{sign.lambda}{Either plot against log(lambda) (default) or its negative if \code{sign.lambda=-1}.}

\item{label.n}{Number of Df labels}

\item{label}{Logical value whether to display labels}

\item{label.label}{Column name used for label text}

\item{label.colour}{Colour for text labels}

\item{label.alpha}{Alpha for text labels}

\item{label.size}{Size for text labels}

\item{label.angle}{Angle for text labels}

\item{label.family}{Font family for text labels}

\item{label.fontface}{Fontface for text labels}

\item{label.lineheight}{Lineheight for text labels}

\item{label.hjust}{Horizontal adjustment for text labels}

\item{label.vjust}{Vertical adjustment for text labels}

\item{label.repel}{Logical flag indicating whether to use \code{ggrepel}, enabling this may take some time for plotting}

\item{xlim}{limits for x axis}

\item{ylim}{limits for y axis}

\item{log}{which variables to log transform ("x", "y", or "xy")}

\item{main}{character vector or expression for plot title}

\item{xlab}{character vector or expression for x axis label}

\item{ylab}{character vector or expression for y axis label}

\item{asp}{the y/x aspect ratio}

\item{...}{other arguments passed to methods}
}
\value{
ggplot
}
\description{
Autoplot \code{glmnet::cv.glmnet}
}
\examples{
autoplot(glmnet::cv.glmnet(data.matrix(Orange[-3]), data.matrix(Orange[3])))
}
