% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outer_glow.R
\name{with_outer_glow}
\alias{with_outer_glow}
\title{Apply an outer glow to your layer}
\usage{
with_outer_glow(x, colour = "black", sigma = 3, expand = 0, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{colour}{The colour of the glow}

\item{sigma}{The standard deviation of the gaussian kernel. Increase it to
apply more blurring. If a numeric it will be interpreted as given in pixels.
If a unit object it will automatically be converted to pixels at rendering
time}

\item{expand}{An added dilation to the glow mask before blurring it}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter adds an outer glow to your layer with a specific colour and size.
For very thin objects such as text it may be beneficial to add some
expansion. See the examples for this.
}
\examples{
library(ggplot2)

ggplot(mtcars, aes(as.factor(gear), disp)) +
  with_outer_glow(
    geom_boxplot(),
    colour = 'red',
    sigma = 10
  )

# For thin objects (as the whiskers above) you may need to add a bit of
# expansion to make the glow visible:

ggplot(mtcars, aes(mpg, disp)) +
  geom_point() +
  with_outer_glow(
    geom_text(aes(label = rownames(mtcars))),
    colour = 'white',
    sigma = 10,
    expand = 10
  )

}
\seealso{
Other glow filters: 
\code{\link{with_inner_glow}()}
}
\concept{glow filters}
