% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_genes.R
\name{theme_genes}
\alias{theme_genes}
\title{A 'ggplot2' theme for drawing gene maps}
\usage{
theme_genes()
}
\description{
This theme removes extraneous plot elements for drawing an
'arrows-on-a-string' style gene map in 'ggplot2'.
}
\details{
This theme removes strip text (the text that labels facets when you use
`facet_wrap` or `facet_grid`). This makes it easier to draw molecules on
different x scales by setting the y aesthetic to the molecule, then faceting
with `facet_grid( ~ molecule, scales = "free")`.
}
\examples{

ggplot2::ggplot(example_genes, ggplot2::aes(xmin = start, xmax = end,
                                            y = molecule, fill = gene)) +
geom_gene_arrow() +
ggplot2::facet_wrap(~ molecule, scales = "free") +
theme_genes()

}
\seealso{
geom_gene_arrows
}
