% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guitar_chords.R
\name{notes_for_frets}
\alias{notes_for_frets}
\title{This function is similar to  \code{\link{chord_for_frets}} but
also handles scales.
Unlike chords_for_frets, this function removes NAs.
This means there are no muted strings identified
if a chord is passed in the frets argument.}
\usage{
notes_for_frets(frets, tuning = c("e", "a", "d", "g", "b", "e"))
}
\arguments{
\item{frets}{A vector representing fret positions.}

\item{tuning}{A 6 element vector representing notes of open strings.}
}
\value{
Returns a vector of note names.
}
\description{
This function is similar to  \code{\link{chord_for_frets}} but
also handles scales.
Unlike chords_for_frets, this function removes NAs.
This means there are no muted strings identified
if a chord is passed in the frets argument.
}
\examples{
G_M_scale <- c(3, 0, 0, 0, NA, NA,
                        NA, 2, 2, NA, NA, NA,
                        NA, 3, 4, NA, NA, NA)
notes_for_frets(G_M_scale)

}
\seealso{
\code{\link{chord_for_frets}}
}

