% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_text_hdx.R
\name{geom_text_hdx}
\alias{geom_text_hdx}
\alias{geom_label_hdx}
\title{Text}
\usage{
geom_text_hdx(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_label_hdx(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  fill = hdx_hex("gray-dark"),
  color = "white",
  fontface = "bold",
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  label.padding = unit(0.25, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointly specified with
\code{nudge_x} or \code{nudge_y}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge labels by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} happens at draw time and in
the order of the data. Therefore data should be arranged by the label
column before calling \code{geom_text()}. Note that this argument is not
supported by \code{geom_label()}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{fill}{Fill color for label box. Defaults to dark gray.}

\item{color}{Font color. Defaults to white.}

\item{fontface}{Font emphasis. Defaults to bold.}

\item{label.padding}{Amount of padding around label. Defaults to 0.25 lines.}

\item{label.r}{Radius of rounded corners. Defaults to 0.15 lines.}

\item{label.size}{Size of label border, in mm.}
}
\value{
A ggplot2 layer that can be added to a \code{ggplot2::ggplot()} plot.
}
\description{
Text geoms are useful for labeling plots. They can be used by themselves as
scatterplots or in combination with other geoms, for example, for labeling
points or for annotating the height of bars. \code{geom_text_hdx()} adds only
text to the plot. \code{geom_label_hdx()} draws a rectangle behind the text,
making it easier to read. The only difference with the base \code{geom_text()}
is that the default font family is Source Sans 3. \code{geom_label_hdx()} also
incorporates a default dark gray background, white text, and no borders.
}
\details{
Note that when you resize a plot, text labels stay the same size, even
though the size of the plot area changes. This happens because the "width"
and "height" of a text element are 0. Obviously, text labels do have height
and width, but they are physical units, not data units. For the same reason,
stacking and dodging text will not work by default, and axis limits are not
automatically expanded to include all text.

\code{geom_text()} and \code{geom_label()} add labels for each row in the
data, even if coordinates x, y are set to single values in the call
to \code{geom_label()} or \code{geom_text()}.
To add labels at specified points use \code{\link[ggplot2:annotate]{annotate()}} with
\code{annotate(geom = "text", ...)} or \code{annotate(geom = "label", ...)}.

To automatically position non-overlapping text labels see the
\href{https://cran.r-project.org/package=ggrepel}{ggrepel}
package.
}
\examples{
library(ggplot2)
load_source_sans_3()

p <- ggplot(
  data = mtcars,
  mapping = aes(
    x = mpg,
    y = mpg,
    label = rownames(mtcars)
  )
)

p + geom_text_hdx()
p + geom_label_hdx()

}
