% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggSpine.R
\name{ggSpine}
\alias{ggSpine}
\title{Draw an interactive spinogram}
\usage{
ggSpine(data, mapping, stat = "count", position = "fill",
  palette = "Blues", interactive = FALSE, polar = FALSE, width = NULL,
  digits = 1, colour = "black", size = 0.2, addlabel = FALSE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string
c("count","identity")}

\item{position}{Position adjustment. One of the c("fill","stack","dodge")}

\item{palette}{A character string indicating the color palette}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{width}{Bar width}

\item{digits}{integer indicating the number of decimal places}

\item{colour}{Bar colour}

\item{size}{Bar size}

\item{addlabel}{A logical value. If TRUE, label will be added to the plot}

\item{...}{other arguments passed on to layer.}
}
\value{
An interactive spinogram
}
\description{
Draw an interactive spinogram
}
\examples{
require(moonBook)
require(ggplot2)
require(ggiraph)
ggSpine(data=acs,aes(x=age,fill=smoking),interactive=TRUE)
ggSpine(data=acs,aes(x=Dx,fill=smoking),addlabel=TRUE,interactive=TRUE)
ggSpine(data=acs,aes(x=Dx,fill=smoking),position="dodge",addlabel=TRUE,interactive=TRUE)
ggSpine(data=acs,aes(x=Dx,fill=smoking),position="stack",addlabel=TRUE,interactive=TRUE)
}

