% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.eval.R
\name{rm.gg2}
\alias{rm.gg2}
\title{Remove \code{ggplot2} style and stand-alone aesthetic arguments (i.e.
\code{y}, \code{x:z}, etc).}
\usage{
rm.gg2(expr)
}
\arguments{
\item{expr}{A parse tree generated by \code{substitute()}. If the tree is not
wrapped by \code{c()} then it is advised to wrap \code{x} with
\code{list()}.}
}
\description{
Expression aesthetics (variables wrapped in functions or using prefix/infix
operators) need to be handled differently than just standalone variable
aesthetics (i.e. \code{mpg}) or \pkg{dplyr}-like variable calls (i.e.
\code{mpg:hp}).
}
\details{
The reason it is advised wrap \code{x} in a \code{list} is due to the way
\code{x} will be indexed/subsetted. The \code{c} function wrapping is
assumed, so therefore the \code{list} wrapping is needed.
}

