% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_stamenmap.R
\name{get_stamenmap}
\alias{get_stamenmap}
\alias{get_stamen_tile_download_fail_log}
\alias{retry_stamen_map_download}
\title{Get a Stamen Map}
\usage{
get_stamenmap(bbox = c(left = -95.80204, bottom = 29.38048, right =
  -94.92313, top = 30.14344), zoom = 10, maptype = c("terrain",
  "terrain-background", "terrain-labels", "terrain-lines", "toner",
  "toner-2010", "toner-2011", "toner-background", "toner-hybrid",
  "toner-labels", "toner-lines", "toner-lite", "watercolor"),
  crop = TRUE, messaging = FALSE, urlonly = FALSE,
  color = c("color", "bw"), force = FALSE, where = tempdir(), ...)

get_stamen_tile_download_fail_log()

retry_stamen_map_download()
}
\arguments{
\item{bbox}{a bounding box in the format c(lowerleftlon, lowerleftlat,
upperrightlon, upperrightlat).}

\item{zoom}{a zoom level}

\item{maptype}{terrain, terrain-background, terrain-labels, terrain-lines,
toner, toner-2010, toner-2011, toner-background, toner-hybrid,
toner-labels, toner-lines, toner-lite, or watercolor.}

\item{crop}{crop raw map tiles to specified bounding box. if FALSE, the
resulting map will more than cover the bounding box specified.}

\item{messaging}{turn messaging on/off}

\item{urlonly}{return url only}

\item{color}{color or black-and-white (use force = TRUE if you've already
downloaded the images)}

\item{force}{if the map is on file, should a new map be looked up?}

\item{where}{where should the file drawer be located (without terminating
"/")}

\item{...}{...}
}
\value{
a ggmap object (a classed raster object with a bounding box
  attribute)
}
\description{
\code{get_stamenmap} accesses a tile server for Stamen Maps and
downloads/stitches map tiles/formats a map image. Note that Stamen maps don't
cover the entire world.
}
\examples{

\dontrun{ some requires Google API key, see ?register_google; heavy network/time load


## basic usage
########################################

bbox <- c(left = -97.1268, bottom = 31.536245, right = -97.099334, top = 31.559652)

ggmap(get_stamenmap(bbox, zoom = 13))
ggmap(get_stamenmap(bbox, zoom = 14))
ggmap(get_stamenmap(bbox, zoom = 15))
ggmap(get_stamenmap(bbox, zoom = 16))


place <- "mount everest"
(google <- get_googlemap(place, zoom = 9))
ggmap(google)
bbox_everest <- c(left = 86.05, bottom = 27.21, right = 87.81, top = 28.76)
ggmap(get_stamenmap(bbox_everest, zoom = 9))



## map types
########################################

place <- "rio de janeiro"
google <- get_googlemap(place, zoom = 10)
ggmap(google)

bbox <- bb2bbox(attr(google, "bb"))

get_stamenmap(bbox, maptype = "terrain")            \%>\% ggmap()
get_stamenmap(bbox, maptype = "terrain-background") \%>\% ggmap()
get_stamenmap(bbox, maptype = "terrain-labels")     \%>\% ggmap()
get_stamenmap(bbox, maptype = "terrain-lines")      \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner")              \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-2010")         \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-2011")         \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-background")   \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-hybrid")       \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-labels")       \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-lines")        \%>\% ggmap()
get_stamenmap(bbox, maptype = "toner-lite")         \%>\% ggmap()
get_stamenmap(bbox, maptype = "watercolor")         \%>\% ggmap()


## zoom levels
########################################

get_stamenmap(bbox, maptype = "watercolor", zoom = 11) \%>\% ggmap(extent = "device")
get_stamenmap(bbox, maptype = "watercolor", zoom = 12) \%>\% ggmap(extent = "device")
get_stamenmap(bbox, maptype = "watercolor", zoom = 13) \%>\% ggmap(extent = "device")
# get_stamenmap(bbox, maptype = "watercolor", zoom = 14) \%>\% ggmap(extent = "device")
# get_stamenmap(bbox, maptype = "watercolor", zoom = 15) \%>\% ggmap(extent = "device")
# get_stamenmap(bbox, maptype = "watercolor", zoom = 16) \%>\% ggmap(extent = "device")
# get_stamenmap(bbox, maptype = "watercolor", zoom = 17) \%>\% ggmap(extent = "device")
# get_stamenmap(bbox, maptype = "watercolor", zoom = 18) \%>\% ggmap(extent = "device")


## more examples
########################################

gc <- geocode("rio de janeiro")

get_stamenmap(bbox, zoom = 10) \%>\% ggmap() +
 geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

get_stamenmap(bbox, zoom = 10, crop = FALSE) \%>\% ggmap() +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

get_stamenmap(bbox, zoom = 10, maptype = "watercolor") \%>\% ggmap() +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)

get_stamenmap(bbox, zoom = 10, maptype = "toner") \%>\% ggmap() +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 2)


# continental united states labels
c("left" = -125, "bottom" = 25.75, "right" = -67, "top" = 49) \%>\%
  get_stamenmap(zoom = 5, maptype = "toner-labels") \%>\%
  ggmap()




# accuracy check - white house
gc <- geocode("the white house")

qmap("the white house", zoom = 16)  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)

qmap("the white house", zoom = 16, source = "stamen", maptype = "terrain")  +
  geom_point(aes(x = lon, y = lat), data = gc, colour = "red", size = 3)



## known issues
########################################

# in some cases stamen's servers will not return a tile for a given map
# this tends to happen in high-zoom situations, but it is not always
# clear why it happens. these tiles will appear as blank parts of the map.

# ggmap provides some tools to try to recover the missing tiles, but the
# servers seem pretty persistent at not providing the maps.

bbox <- c(left = -97.1268, bottom = 31.536245, right = -97.099334, top = 31.559652)
ggmap(get_stamenmap(bbox, zoom = 17))
get_stamen_tile_download_fail_log()
retry_stamen_map_download()




}


}
\seealso{
\url{http://maps.stamen.com/#watercolor}, \code{\link{ggmap}}
}
