% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_sf_coordinates_inset.R
\docType{data}
\name{stat_sf_coordinates_inset}
\alias{stat_sf_coordinates_inset}
\alias{StatSfCoordinatesInset}
\title{Extract coordinates from 'sf' objects (inset-aware)}
\usage{
stat_sf_coordinates_inset(
  mapping = ggplot2::aes(),
  data = NULL,
  geom = "point",
  position = "identity",
  ...,
  inset = NA,
  fun.geometry = NULL,
  where = "inset",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, geom, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:stat_sf_coordinates]{ggplot2::stat_sf_coordinates()}}.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[=coord_sf_inset]{coord_sf_inset()}}).}

\item{fun.geometry}{A function that takes a \code{sfc} object and returns a \code{sfc_POINT} with the
same length as the input. If \code{NULL}, \code{function(x) sf::st_point_on_surface(sf::st_zm(x))}
will be used. Note that the function may warn about the incorrectness of
the result if the data is not projected, but you can ignore this except
when you really care about the exact locations.}

\item{where}{Specifies how the text position interacts with the inset.
\code{"inset"} means that any points in the inset area are drawn on the inset map,
\code{"base"} puts them on the base map. This setting is merely a shorthand for
setting the position aesthetics to \code{after_stat(x_inset)} or \code{after_stat(x)}
respectively, so will have no effect if these are specified in the mapping.}
}
\value{
A plot layer
}
\description{
Reduce spatial data to coordinates in the same way as \code{\link[ggplot2:stat_sf_coordinates]{stat_sf_coordinates()}}.
The result can then be used by \code{\link[ggplot2:ggsf]{geom_sf()}} or
\code{\link[=geom_sf_inset]{geom_sf_inset()}} or any geom that needs \code{x} and
\code{y} aesthetics.
}
\section{Required aesthetics}{

\describe{
\item{geometry}{The sf geometry column containing spatial features}
}
}

\section{Computed variables}{

\describe{
\item{x}{X dimension of the simple feature}
\item{y}{Y dimension of the simple feature}
\item{x_inset}{X dimension of the simple feature after inset transformation}
\item{y_inset}{Y dimension of the simple feature after inset transformation}
\item{inside_inset}{logical indicating points inside the inset viewport}
\item{inset_scale}{1 for points outside the inset, otherwise the configured inset scale parameter}
}
}

\examples{
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

ggplot(nc) +
  geom_sf_inset() +
  geom_inset_frame() +
  geom_sf_text(aes(x = after_stat(x_inset), y = after_stat(y_inset), label = NAME),
    stat = "sf_coordinates_inset") +
  coord_sf_inset(inset = configure_inset(
    centre = sf::st_sfc(sf::st_point(c(-80, 35.5)), crs = 4326),
    scale = 1.5, translation = c(-50, -140), radius = 50, units = "mi"))
}
\keyword{datasets}
