% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ggmix_gic}
\alias{plot.ggmix_gic}
\alias{plotGIC}
\title{Plot the Generalised Information Criteria curve produced by \code{gic}}
\usage{
\method{plot}{ggmix_gic}(
  x,
  ...,
  sign.lambda = 1,
  type = c("gic", "QQranef", "QQresid", "predicted", "Tukey-Anscombe"),
  s = "lambda.min",
  newy,
  newx
)

plotGIC(x, sign.lambda, lambda.min, ...)
}
\arguments{
\item{x}{fitted linear mixed model object of class \code{ggmix_gic} from the
\code{\link{gic}} function}

\item{...}{Other graphical parameters to plot}

\item{sign.lambda}{Either plot against log(lambda) (default) or its negative
if sign.lambda=-1}

\item{type}{\code{gic} returns a plot of the GIC vs. log(lambda).
\code{QQranef} return a qqplot of the random effects. \code{QQresid}
returns a qqplot of the residuals which is \eqn{y - X\beta - b_i} where b_i
is the subject specific random effect. \code{predicted} returns a plot of
the predicted response (\eqn{X \beta} + b_i) vs. the observed response,
where b_i is the subject specific random effect. \code{Tukey-Anscombe}
returns a plot of the residuals vs. fitted values (\eqn{X \beta})}

\item{s}{Value of the penalty parameter \code{lambda} at which predictions
are required. Default is the value \code{s="lambda.min"}. If \code{s} is
numeric, it is taken as the value of \code{lambda} to be used. Must be a
single value of the penalty parameter \code{lambda} at which coefficients
will be extracted via the \code{coef} method for objects of class
\code{ggmix_gic}. If more than one is supplied, only the first one will be
used.}

\item{newy}{the response variable that was provided to \code{ggmix}. this is
only required for \code{type="QQresis"}, \code{type="Tukey-Anscombe"} and
\code{type="predicted"}}

\item{newx}{matrix of values for \code{x} at which predictions are to be
made. Do not include the intercept. this is only required for
\code{type="QQresis"}, \code{type="Tukey-Anscombe"} and
\code{type="predicted"}}

\item{lambda.min}{the value of lambda which minimizes the gic}
}
\value{
plot depends on the type selected
}
\description{
Plots the Generalised Information Criteria curve, as a function
  of the lambda values used
}
\details{
A plot is produced, and nothing is returned.
}
\examples{
data("admixed")
fit <- ggmix(x = admixed$xtrain,
             y = admixed$ytrain,
             kinship = admixed$kin_train)
hdbic <- gic(fit)

# plot solution path
plot(fit)

# plot HDBIC curve as a function of lambda
plot(hdbic)
}
\seealso{
\code{\link{gic}}
}
