% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SupplementaryFunctions.R
\name{get_population_df}
\alias{get_population_df}
\title{Extract population data from a larger data frame}
\usage{
get_population_df(df)
}
\arguments{
\item{df}{Dataframe inclduing column names "Generation", "Parent" and "Identity"}
}
\value{
A dataframe comprising the population dynamics.
}
\description{
Extract population data from a larger data frame
}
\examples{
# extract the adjacency matrix from the data frame:
edges <- get_edges(example_df)

# extract the populations (and any other attributes) from the data frame:
pop_df <- get_population_df(example_df)

# create data frame for plot:
Muller_df <- get_Muller_df(edges, pop_df)

require(RColorBrewer) # for the palette

# draw plot:
num_cols <- length(unique(Muller_df$RelativeFitness)) + 1
Muller_df$RelativeFitness <- as.factor(Muller_df$RelativeFitness)
Muller_plot(Muller_df, colour_by = "RelativeFitness", 
            palette = rev(colorRampPalette(brewer.pal(9, "YlOrRd"))(num_cols)), 
            add_legend = TRUE)

}
\seealso{
\code{\link{get_edges}}
}
\author{
Rob Noble, \email{robjohnnoble@gmail.com}
}
