% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_totalseats.R
\name{draw_totalseats}
\alias{draw_totalseats}
\title{Draw total number of seats in the middle of the parliament}
\usage{
draw_totalseats(n = NULL, size = 12, colour = "black",
  type = c("horseshoe", "semicircle", "opposing_benches", "circle",
  "classroom"))
}
\arguments{
\item{n}{The number of total seats in the legislature.}

\item{size}{Size of font}

\item{colour}{colour of label}

\item{type}{Type of parliament (horseshoe, semicircle, circle, opposing benches, classroom)}
}
\description{
Draw total number of seats in the middle of the parliament
}
\examples{
data <- election_data[
  election_data$country == "USA" &
  election_data$house == "Representatives" &
  election_data$year == "2016",
]
usa_data <- parliament_data(
  election_data = data,
  type = "semicircle",
  party_seats = data$seats,
  parl_rows = 8
)
ggplot2::ggplot(usa_data, ggplot2::aes(x, y, colour = party_long)) +
  geom_parliament_seats() +
  draw_totalseats(n = 435, type = 'semicircle') +
  theme_ggparliament()
}
\author{
Zoe Meers
}
