% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_parliament_bar.R
\name{geom_parliament_bar}
\alias{geom_parliament_bar}
\title{Add a bar showing proportion of seats by party in parliament}
\usage{
geom_parliament_bar(colour = colour, party = party, label = TRUE)
}
\arguments{
\item{colour}{The colours associated with each political party.}

\item{party}{The party name variable in your data frame.}

\item{label}{If label = TRUE, print the percentage above the bar.}
}
\description{
Add a bar showing proportion of seats by party in parliament
}
\examples{
data <- election_data[election_data$country == "USA" &
election_data$house == "Representatives" &
election_data$year == "2016",]
usa_data <- parliament_data(election_data = data,
type = "semicircle",
party_seats = data$seats,
parl_rows = 8)
ggplot2::ggplot(usa_data, ggplot2::aes(x, y, colour = party_long)) +
geom_parliament_seats() +
geom_parliament_bar(colour, party_long) +
ggplot2::scale_colour_manual(values = usa_data$colour, limits = usa_data$party_long)  +
theme_ggparliament()
}
\author{
Zoe Meers
}
