% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpmisc.R
\docType{package}
\name{ggpmisc-package}
\alias{ggpmisc}
\alias{ggpmisc-package}
\title{Miscellaneous Extensions to 'ggplot2'}
\description{
Extensions to 'ggplot2' respecting the grammar of graphics
paradigm. Provides new statistics to locate and tag peaks and valleys in 2D
plots, a statistics to add a label with the equation of a polynomial fitted
with lm(), or R^2 or adjusted R^2 or information criteria for any model
fitted with function lm(). Additional statistics give access to functions
in package 'broom'. Provides a function for flexibly converting time
series to data frames suitable for plotting with ggplot(). In addition
provides two statistics and two geometries useful for diagnosing what data
are passed to compute_group() and compute_panel() functions and to
geometries.
}
\details{
The new facilities for cleanly defining new stats and geoms added to
'ggplot2' in version 2.0.0 have made this package easy to code. However, this
means that this package requires version 2.0.0 or later of ggplot2.

Extensions provided:
\itemize{
\item Function for conversion of time series data into data frames that can be
plotted with ggplot.
\item Stats for locating and tagging "peaks" and "valleys" (local or global
 maxima and minima).
\item Stat for generating labels from a \code{lm()} model fit, including
formatted equation. By default labels are expressions but tikz device is
supported optionally with LaTeX formatted labels.
\item Stats for extracting information from a any model fit supported by
package 'broom'.
\item "Debug" stats and a "debug" geom that print to the console a summary
ot their \code{data} input.
}

The stats for peaks and valleys are coded so as to work correctly both with
numeric and POSIXct variables mapped to the x aesthetic. Special handling was
needed as text labels are generated from the data.
}
\note{
The signatures of \code{stat_peaks()} and \code{stat_valleys()} are
  identical to those of \code{stat_peaks} and \code{stat_valleys} from
  package \code{photobiology} but the variables returned are a subset as
  values related to light spectra are missing. Furthermore the stats from
  package \code{ggpmisc} work correctly when the x aesthetic uses a date or
  datetime scale, while those from package \code{photobiology} do not
  generate correct labels in this case.
}
\author{
Pedro J. Aphalo
}
\references{
Package suite 'r4photobiology' web site at
\url{http://www.r4photobiology.info/}\cr
Package 'ggplot2' web site at \url{http://ggplot2.org/}\cr
Package 'ggplot2' documentation at \url{http://docs.ggplot2.org/}\cr
Package 'ggplot2' source code at \url{https://github.com/hadley/ggplot2}
}

