% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_edge_alpha.R
\name{scale_edge_alpha}
\alias{scale_edge_alpha}
\alias{scale_edge_alpha}
\alias{scale_edge_alpha_continuous}
\alias{scale_edge_alpha_discrete}
\alias{scale_edge_alpha_manual}
\alias{scale_edge_alpha_identity}
\title{Edge alpha scales}
\usage{
scale_edge_alpha(..., range = c(0.1, 1))

scale_edge_alpha_continuous(..., range = c(0.1, 1))

scale_edge_alpha_discrete(..., range = c(0.1, 1))

scale_edge_alpha_manual(..., values)

scale_edge_alpha_identity(..., guide = "none")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link{continuous_scale}}
or \code{\link{discrete_scale}} as appropriate, to control name, limits,
breaks, labels and so forth.}

\item{range}{Output range of alpha values. Must lie between 0 and 1.}

\item{values}{a set of aesthetic values to map data values to. If this
is a named vector, then the values will be matched based on the names.
If unnamed, values will be matched in order (usually alphabetical) with
the limits of the scale. Any data values that don't match will be
given \code{na.value}.}

\item{guide}{Guide to use for this scale. Defaults to \code{"none"}.}
}
\value{
A ggproto object inheriting from \code{Scale}
}
\description{
This set of scales defines new alpha scales for edge geoms equivalent to the
ones already defined by ggplot2. See \code{\link[ggplot2]{scale_alpha}} for
more information. The different geoms will know whether to use edge scales or
the standard scales so it is not necessary to write \code{edge_alpha} in
the call to the geom - just use \code{alpha}.
}
\seealso{
Other scale_edge_*: \code{\link{scale_edge_colour}},
  \code{\link{scale_edge_fill}},
  \code{\link{scale_edge_linetype}},
  \code{\link{scale_edge_shape}},
  \code{\link{scale_edge_size}},
  \code{\link{scale_edge_width}},
  \code{\link{scale_label_size}}
}
