% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmprskstdca.R
\name{cmprskstdca}
\alias{cmprskstdca}
\title{cmprskstdca}
\arguments{
\item{data}{a data frame containing the variables in the model.}

\item{outcome}{the outcome, response variable. Must be a variable contained within the data frame specified in data=.}

\item{predictors}{the predictor variable(s). Must be a variable(s) contained within the data frame specified in data=.}

\item{probability}{specifies whether or not each of the independent variables are probabilities. The default is TRUE.}

\item{xstart}{starting value for x-axis (threshold probability) between 0 and 1. The default is 0.01.}

\item{xstop}{stopping value for x-axis (threshold probability) between 0 and 1. The default is 0.99.}

\item{xby}{increment for threshold probability. The default is 0.01.}

\item{ymin}{minimum bound for graph.}

\item{harm}{specifies the harm(s) associated with the independent variable(s). The default is none.}

\item{graph}{specifies whether or not to display graph of net benefits. The default is TRUE.}

\item{intervention}{plot net reduction in interventions}

\item{interventionper}{number of net reduction in interventions per interger. The default is 100}

\item{loess.span}{specifies the degree of smoothing. The default is 0.10.}

\item{timepoint}{specifies the time point at which the decision curve analysis is performed.}

\item{cmprsk}{if evaluating outcome in presence of a competing risk. The default is FALSE}

\item{smooth}{specifies whether or not to smooth net benefit curve. The default is FALSE.}

\item{ttoutcome}{Enter the time variable in your data.}
}
\value{
Returns a data for plotting a decision curve.
}
\description{
Generate data for plotting survival analysis decision curves.
}
\details{
This function was created and written by Dr Andrew Vickers to generate decision curve data.
}
