% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-label-peaks.R
\name{stat_label_peaks}
\alias{stat_label_peaks}
\alias{stat_label_valleys}
\title{Label peaks and valleys.}
\usage{
stat_label_peaks(mapping = NULL, data = NULL, geom = "text",
  span = 5, ignore_threshold = 0, strict = TRUE,
  label.fmt = "\%.3g", x.label.fmt = label.fmt,
  y.label.fmt = label.fmt, label.fill = "", position = "identity",
  na.rm = TRUE, show.legend = FALSE, inherit.aes = TRUE, ...)

stat_label_valleys(mapping = NULL, data = NULL, geom = "text",
  span = 5, ignore_threshold = 0, strict = TRUE,
  label.fmt = "\%.3g", x.label.fmt = label.fmt,
  y.label.fmt = label.fmt, label.fill = "", position = "identity",
  na.rm = TRUE, show.legend = FALSE, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 5, meaning that a peak is bigger than two
consequtive neighbors on each side. Default: 5.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the size
threshold below which peaks will be ignored.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: FALSE.}

\item{label.fmt}{character  string giving a format definition for converting
values into character strings by means of function \code{\link{sprintf}}.}

\item{x.label.fmt}{character  string giving a format definition for
converting $x$-values into character strings by means of function
\code{\link{sprintf}}.}

\item{y.label.fmt}{character  string giving a format definition for
converting $y$-values into character strings by means of function
\code{\link{sprintf}}.}

\item{label.fill}{character string ot use for labels not at peaks or valleys
being highlighted.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
The original data with additional computed variables added.
}
\description{
\code{stat_labels_peaks} finds at which x positions local maxima are located,
and adds labels and colors to the data wihtout subsetting. To find local
minima, you can use \code{stat_labels_valleys} instead.
}
\details{
These stats use \code{geom_text} by default as it is the geom most
  likely to work well in almost any situation without need of tweaking. These
  statistics work best with \code{geom_text_repel} and
  \code{geom_label_repel} from package 'ggrepel' as they are designed so that
  peak or valley labels will not overlapT any observation in the whole data
  set. Default aesthetics set by these stats allow their direct use with
  \code{geom_text}, \code{geom_label}, \code{geom_line}, \code{geom_rug},
  \code{geom_hline} and \code{geom_vline}. The formatting of the labels
  returned can be controlled by the user.
}
\note{
These stats work nicely together with geoms \code{geom_text_repel} and
  \code{geom_label_repel} from package \code{\link[ggrepel]{ggrepel}} to
  solve the problem of overlapping labels by displacing them. To discard
  overlapping labels use \code{check_overlap = TRUE} as argument to
  \code{geom_text}. By default the labels are character values suitable to be
  plotted as is, but with a suitable \code{label.fmt} labels suitable for
  parsing by the geoms (e.g. into expressions containing greek letters or
  super or subscripts) can be also easily obtained.
}
\section{Computed variables}{
 \describe{ \item{x.label}{x-value at a peak (or
  valley) formatted as character or otherwise the
  value passed to \code{label.fill} which defaults to an
  empty string (\code{""}).}
  \item{y.label}{y-value at the peak (or valley) formatted as character or
   otherwise the value passed to \code{label.fill} which defaults to an
  empty string (\code{""}).}
  \item{wl.color}{At peaks and valleys,
  color definition calculated by assuming that x-values are wavelengths
  expressed in nanometres, otherwise, \code{rgb(1, 1, 1, 0)} (transparent
  white).} }
}

\section{Default aesthetics}{
 Set by the statistic and available to geoms.
  \describe{ \item{label}{..x.label..} \item{xintercept}{..x..}
  \item{yintercept}{..y..} \item{color}{black_or_white(..wl.color..)}
  \item{fill}{..wl.color..} }
}

\section{Required aesthetics}{
 Required by the statistic and need to be set
  with \code{aes()}. \describe{ \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity} }
}

\examples{
library(photobiology)
library(ggplot2)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) + geom_line() +
  stat_label_peaks(hjust = "left", span = 31, angle = 90, color = "red")
ggplot(sun.spct) + geom_line() +
  stat_label_valleys(hjust = "right", span = 21, angle = 90, color = "blue")

# using 'ggrepel' to avoid overlaps
# too slow for CRAN checks
\dontrun{
library(ggrepel)
library(photobiology)
ggplot(sun.spct) + geom_line() +
  stat_peaks(span = 41, shape = 21, size = 3) +
  stat_label_peaks(span = 41, geom = "label_repel", segment.colour = "red",
                   nudge_y = 0.12, label.fmt = "\%3.0f nm") +
  scale_fill_identity() +
  scale_color_identity() +
  expand_limits(y = c(NA, 1))
}

}
\seealso{
\code{\link{stat_peaks}}, \code{\link{stat_valleys}} and
  \code{\link[photobiology]{find_peaks}}, which is used internally.

Other stats functions: \code{\link{stat_color}},
  \code{\link{stat_find_qtys}},
  \code{\link{stat_find_wls}}, \code{\link{stat_peaks}},
  \code{\link{stat_wb_box}}, \code{\link{stat_wb_column}},
  \code{\link{stat_wb_contribution}},
  \code{\link{stat_wb_hbar}}, \code{\link{stat_wb_irrad}},
  \code{\link{stat_wb_label}}, \code{\link{stat_wb_mean}},
  \code{\link{stat_wb_relative}},
  \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_total}}, \code{\link{stat_wl_strip}},
  \code{\link{stat_wl_summary}}
}
\concept{stats functions}
