% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetric_limits.R
\name{symmetric_limits}
\alias{symmetric_limits}
\title{Symmetric limits}
\source{
Adapted from the homonym function in \code{{ggpmisc}}
}
\usage{
symmetric_limits(x)
}
\arguments{
\item{x}{a vector of numeric values, possibly a range, from which to compute
enclosing range}
}
\value{
A numeric vector of length two with the new limits, which are always
such that the absolute value of upper and lower limits is the same.
}
\description{
Expand scale limits to make them symmetric around zero.
Can be passed as argument to parameter \code{limits} of continuous scales from
packages \code{{ggplot2}} or \code{{scales}}. Can be also used to obtain an enclosing
symmetric range for numeric vectors.
}
\examples{
library(ggplot2)

ggplot(iris) +
  aes(x = Sepal.Length - 5, y = Sepal.Width - 3, colour = Species) +
  geom_vline(xintercept = 0) +
  geom_hline(yintercept = 0) +
  geom_point()

last_plot() +
  scale_x_continuous(limits = symmetric_limits) +
  scale_y_continuous(limits = symmetric_limits)
}
