% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_t_subtitles.R
\name{effsize_t_parametric}
\alias{effsize_t_parametric}
\title{Calculating Cohen's \emph{d} or Hedge's \emph{g} (for between-/within- or one
sample designs).}
\usage{
effsize_t_parametric(formula = NULL, data = NULL, mu = 0,
  paired = FALSE, hedges.correction = TRUE, conf.level = NULL,
  var.equal = NULL, noncentral = TRUE, tobject = NULL, ...)
}
\arguments{
\item{formula}{This function only accepts the variables in \code{formula} format
e.g. \code{sleep_rem ~ vore} or \code{~ vore}.}

\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{mu}{If conducting a single sample test against a mean (Default: \code{0}).}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{hedges.correction}{Logical indicating whether to apply Hedges
correction, Hedge's \emph{g} (Default: \code{TRUE}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence intervals (Default: \code{TRUE}).}

\item{tobject}{Object with the \emph{t}-test specification.}

\item{...}{Additional arguments.}
}
\description{
Calculating Cohen's \emph{d} or Hedge's \emph{g} (for between-/within- or one
sample designs).
}
\details{
This function is a rewrite of functionality provided in \code{lsr::cohensD} and
\code{effsize::cohen.d}.

References-
\itemize{
\item Cooper, Harris, Hedges, Larry V., Valentine, Jeffrey C., The Handbook
of Research Synthesis and Meta-Analysis, 2009. \item Cumming, G., Finch, S.,
A Primer On The Understanding, Use, And Calculation Of Confidence Intervals
That Are Based On Central And Noncentral Distributions, Educational and
Psychological Measurement, Vol. 61 No. 4, August 2001 532-574. \item Cohen,
J. (1988). Statistical power analysis for the behavioral sciences (2nd ed.)
Hillsdale, NJ: Lawrence Erlbaum Associates. \item David C. Howell (2010).
Confidence Intervals on Effect Size, retrieved from
(\url{https://www.uvm.edu/~dhowell/methods7/Supplements/Confidence\%20Intervals\%20on\%20Effect\%20Size.pdf}).
}
}
\examples{
\dontrun{
#---------------- two-sample test ------------------------------------

# creating a smaller dataset
msleep_short <- dplyr::filter(
  .data = ggplot2::msleep,
  vore \%in\% c("carni", "herbi")
)

# with defaults
ggstatsplot::effsize_t_parametric(
  formula = sleep_rem ~ vore,
  data = msleep_short,
)

# changing defaults
ggstatsplot::effsize_t_parametric(
  formula = sleep_rem ~ vore,
  data = msleep_short,
  mu = 1, # ignored in this case
  paired = FALSE,
  hedges.correction = TRUE,
  conf.level = .99,
  noncentral = FALSE
)

#---------------- one-sample test ------------------------------------

ggstatsplot::effsize_t_parametric(
  formula = ~sleep_rem,
  data = msleep_short,
  mu = 2,
  hedges.correction = TRUE,
  conf.level = .90,
  noncentral = TRUE
)
}
}
\author{
Chuck Powell
}
\keyword{internal}
