% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcorrmat.R
\name{ggcorrmat}
\alias{ggcorrmat}
\title{Visualization of a correlation matrix}
\usage{
ggcorrmat(
  data,
  cor.vars = NULL,
  cor.vars.names = NULL,
  output = "plot",
  matrix.type = "upper",
  type = "parametric",
  tr = 0.2,
  partial = FALSE,
  k = 2L,
  sig.level = 0.05,
  conf.level = 0.95,
  bf.prior = 0.707,
  p.adjust.method = "holm",
  pch = "cross",
  ggcorrplot.args = list(method = "square", outline.color = "black", pch.cex = 14),
  package = "RColorBrewer",
  palette = "Dark2",
  colors = c("#E69F00", "white", "#009E73"),
  ggtheme = ggstatsplot::theme_ggstatsplot(),
  ggplot.component = NULL,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{cor.vars}{List of variables for which the correlation matrix is to be
computed and visualized. If \code{NULL} (default), all numeric variables from
\code{data} will be used.}

\item{cor.vars.names}{Optional list of names to be used for \code{cor.vars}. The
names should be entered in the same order.}

\item{output}{Character that decides expected output from this function. If
\code{"plot"}, the visualization matrix will be returned. If \code{"dataframe"} (or
literally anything other than \code{"plot"}), a data frame containing all details
from statistical analyses (e.g., correlation coefficients, statistic
values, \emph{p}-values, no. of observations, etc.) will be returned.}

\item{matrix.type}{Character, \code{"upper"} (default), \code{"lower"}, or \code{"full"},
display full matrix, lower triangular or upper triangular matrix.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{partial}{Can be \code{TRUE} for partial correlations. For Bayesian partial
correlations, "full" instead of pseudo-Bayesian partial correlations (i.e.,
Bayesian correlation based on frequentist partialization) are returned.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{sig.level}{Significance level (Default: \code{0.05}). If the \emph{p}-value in
\emph{p}-value matrix is bigger than \code{sig.level}, then the corresponding
correlation coefficient is regarded as insignificant and flagged as such in
the plot. Relevant only when \code{output = "plot"}.}

\item{conf.level}{Scalar between \code{0} and \code{1}. If unspecified, the defaults
return \verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of 1/2, sqrt(2)/2, and 1, respectively. In case of an ANOVA, this value
corresponds to scale for fixed effects.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{pch}{Decides the point shape to be used for insignificant correlation
coefficients (only valid when \code{insig = "pch"}). Default: \code{pch = "cross"}.}

\item{ggcorrplot.args}{A list of additional (mostly aesthetic) arguments that
will be passed to \code{ggcorrplot::ggcorrplot} function. The list should avoid
any of the following arguments since they are already internally being
used: \code{corr}, \code{method}, \code{p.mat}, \code{sig.level}, \code{ggtheme}, \code{colors}, \code{lab},
\code{pch}, \code{legend.title}, \code{digits}.}

\item{package, palette}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}

\item{colors}{A vector of 3 colors for low, mid, and high correlation values.
If set to \code{NULL}, manual specification of colors will be turned off and 3
colors from the specified \code{palette} from \code{package} will be selected.}

\item{ggtheme}{A \code{{ggplot2}} theme. Default value is
\code{ggstatsplot::theme_ggstatsplot()}. Any of the \code{{ggplot2}} themes (e.g.,
\code{theme_bw()}), or themes from extension packages are allowed (e.g.,
\code{ggthemes::theme_fivethirtyeight()}, \code{hrbrthemes::theme_ipsum_ps()}, etc.).
But note that sometimes these themes will remove some of the details that
\code{{ggstatsplot}} plots typically contains. For example, if relevant,
\code{ggbetweenstats()} shows details about multiple comparison test as a label
on the secondary Y-axis. Some themes (e.g.
\code{ggthemes::theme_fivethirtyeight()}) will remove the secondary Y-axis and
thus the details as well.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{{ggstatsplot}}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{{ggplot2}} function or a list of \code{{ggplot2}} functions.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{caption}{The text for the plot caption. This argument is relevant only
if \code{bf.message = FALSE}.}

\item{...}{Currently ignored.}
}
\description{
Correlation matrix or a data frame containing results from pairwise
correlation tests. The package internally uses \code{ggcorrplot::ggcorrplot} for
creating the visualization matrix, while the correlation analysis is carried
out using the \code{correlation::correlation} function.
}
\details{
For details, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggcorrmat.html}
}
\examples{
# for reproducibility
set.seed(123)
library(ggstatsplot)

# to get a plot (assumes that `ggcorrplot` is installed)
if (require("ggcorrplot")) ggcorrmat(iris)

# to get a data frame
ggcorrmat(
  data = ggplot2::msleep,
  cor.vars = sleep_total:bodywt,
  partial = TRUE,
  output = "dataframe"
)
}
\seealso{
\code{\link{grouped_ggcorrmat}} \code{\link{ggscatterstats}}
\code{\link{grouped_ggscatterstats}}
}
