% Generated by roxygen2 (4.0.1): do not edit by hand
\name{compute_smooth}
\alias{compute_smooth}
\title{Smooth data with a model.}
\usage{
compute_smooth(x, formula, ..., method = NULL, se = FALSE, level = 0.95,
  n = 80L)
}
\arguments{
\item{x}{Dataset-like object to smooth. Built-in methods for data frames,
grouped data frames and ggvis visualisations.}

\item{method}{Model fitting function to use - it must support R's standard
modelling interface, taking a formula and data frame as input, and
returning predictions with \code{\link{predict}}. If not supplied, will
use \code{\link{loess}} for <= 1000 points, otherwise it will use
\code{\link[mgcv]{gam}}. Other modelling functions that will work include
\code{\link{lm}}, \code{\link{glm}} and \code{\link[MASS]{rlm}}.}

\item{formula}{Formula passed to modelling function. Can use any variables
from data.}

\item{se}{include standard errors in output? Requires appropriate method of
\code{predict_grid}, since the interface for returning predictions with
standard errors is not consistent acrossing modelling frameworks.}

\item{level}{the confidence level of the standard errors.}

\item{n}{the number of grid points to use in the prediction}

\item{...}{arguments passed on to \code{method} function}
}
\value{
A data frame with columns:
 \item{\code{resp_}}{regularly spaced grid of \code{n} locations}
 \item{\code{pred_}}{predicted value from smooth}
 \item{\code{pred_lwr_} and \code{pred_upr_}}{upper and lower bounds of
   confidence interval (if \code{se = TRUE})}
 \item{\code{pred_se_}}{the standard error (width of the confidence interval)
   (if \code{se = TRUE})}
}
\description{
Fit a 1d model, then compute predictions and (optionally) standard errors
over an evenly spaced grid.
}
\examples{
mtcars \%>\% compute_smooth(mpg ~ wt, n = 10)
mtcars \%>\% compute_smooth(mpg ~ wt, n = 10, se = TRUE)
mtcars \%>\% group_by(cyl) \%>\% compute_smooth(mpg ~ wt, n = 10)

# Override method to suppress message or change approach
mtcars \%>\% compute_smooth(mpg ~ wt, n = 10, method = "loess")
mtcars \%>\% compute_smooth(mpg ~ wt, n = 10, method = "lm")

# Plot the results
mtcars \%>\% compute_smooth(mpg ~ wt) \%>\% ggvis(~pred_, ~resp_) \%>\% layer_paths()
mtcars \%>\% ggvis() \%>\% compute_smooth(mpg ~ wt) \%>\% layer_paths(~pred_, ~resp_)
}

