% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/layer_bars.R
\name{layer_bars}
\alias{layer_bars}
\title{Display data with bars (a barchart).}
\usage{
layer_bars(vis, ..., stack = TRUE, width = NULL)
}
\arguments{
\item{vis}{Visualisation to modify}

\item{...}{Visual properties used to override defaults.}

\item{stack}{If there are multiple bars to be drawn at an x location, should
the bars be stacked? If FALSE, the bars will be overplotted on each other.}

\item{width}{Width of each bar. When x is continuous, this controls the width
in the same units as x. When x is categorical, this controls the width as a
proportion of the spacing between items (default is 0.9).}
}
\description{
This will add bars to a plot. The exact behavior is complicated because
the term bar chart is used to describe four important variations on a theme.
The action of \code{layer_bars} depends on two factors: whether or not a
\code{y} prop has been specified, and whether the \code{x} props is
continuous or categorical.
}
\section{Visualisations}{


If no y prop has been specified, then this will count the number of entries
at each unique x value. There will be one bar at each unique x value, and
the y value (or height) of each bar will represent the count at that x value.

If a y prop has been specified, then those y values will be used as weights
for a weighted count at each unique x value. If no x values appear more than
once in the data, then the end result is a plot where the height of the bar
at each x value is simply the y value. However, if an x value appear more
than once in the data, then this will sum up the y values at each x.

If the x variable is continuous, then a continuous x axis will be used, and
the width of each bar is by default equal to the resolution of the data --
that is, the smallest difference between any two x values.

If the x variable is categorical, then a categorical x axis will be used. By
default, the width of each bar is 0.9 times the space between the items.
}
\examples{
# Discrete x: bar graph of counts at each x value
cocaine \%>\% ggvis(~state) \%>\% layer_bars()
# Continuous x: bar graph of counts at unique locations
cocaine \%>\% ggvis(~month) \%>\% layer_bars()

# Use y prop to weight by additional variable. This is also useful
# if you have pretabulated data
cocaine \%>\% ggvis(~state, ~weight) \%>\% layer_bars()
cocaine \%>\% ggvis(~month, ~weight) \%>\% layer_bars()

# For continuous x, layer_bars is useful when the variable has a few
# unique values that you want to preserve. If you have many unique
# values and you want to bin, use layer_histogram
cocaine \%>\% ggvis(~price) \%>\% layer_bars()
cocaine \%>\% ggvis(~price) \%>\% layer_histograms(width = 100)

# If you have unique x values, you can use layer_bars() as an alternative
# to layer_points()
pressure \%>\% ggvis(~temperature, ~pressure) \%>\% layer_points()
pressure \%>\% ggvis(~temperature, ~pressure) \%>\% layer_bars()

# When x is continuous, width controls the width in x units
pressure \%>\% ggvis(~temperature, ~pressure) \%>\% layer_bars(width = 10)
# When x is categorical, width is proportional to spacing between bars
pressure \%>\% ggvis(~factor(temperature), ~pressure) \%>\%
  layer_bars(width = 0.5)

# Stacked bars
# If grouping var is continuous, you need to manually specify grouping
ToothGrowth \%>\% group_by(dose) \%>\%
  ggvis(x = ~supp, y = ~len, fill = ~dose) \%>\% layer_bars()
# If grouping var is categorical, grouping is done automatically
cocaine \%>\% ggvis(x = ~state, fill = ~as.factor(month)) \%>\%
  layer_bars()
}
\seealso{
\code{\link{layer_histograms}} For bar graphs of counts at each unique
  x value, in contrast to a histogram's bins along x ranges.

\code{\link{compute_count}} and \code{\link{compute_tabulate}} for
  more information on how data is transformed.
}

