% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/handle_keyboard.R
\name{left_right}
\alias{left_right}
\alias{up_down}
\title{Interactive inputs bound to arrow keys.}
\usage{
left_right(min, max, value = (min + max)/2, step = (max - min)/40)

up_down(min, max, value = (min + max)/2, step = (max - min)/40)
}
\arguments{
\item{min}{A minimum value.}

\item{max}{A maximum value.}

\item{value}{The initial value before any keys are pressed. Defaults to
half-way between \code{min} and \code{max}.}

\item{step}{How much each key press changes \code{value}. Defaults to
40 steps along range}
}
\description{
Interactive inputs bound to arrow keys.
}
\examples{
size <- left_right(1, 801, value = 51, step = 50)
opacity <- up_down(0, 1, value = 0.9, step = 0.05)

mtcars \%>\% ggvis(~mpg, ~wt, size := size, opacity := opacity) \%>\%
  layer_points()
}

