% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/scales.R
\name{scale_datetime}
\alias{scale_datetime}
\title{Add a date-time scale to a ggvis object.}
\usage{
scale_datetime(vis, property, domain = NULL, range = NULL, reverse = NULL,
  round = NULL, utc = NULL, clamp = NULL, nice = NULL, expand = NULL,
  name = property, label = NULL, override = NULL)
}
\arguments{
\item{vis}{A ggvis object.}

\item{property}{The name of a property, such as "x", "y", "fill", "stroke", etc.}

\item{domain}{The domain of the scale, representing the set of data values.
For ordinal scales, a character vector; for quantitative scales, a numeric
vector of length two. Either value (but not both) may be NA, in which
case \code{domainMin} or \code{domainMax} is set. For dynamic scales, this
can also be a reactive which returns the appropriate type of vector.}

\item{range}{The range of the scale, representing the set of visual values.
For numeric values, the range can take the form of a two-element array with
minimum and maximum values. For ordinal data, the range may by an array of
desired output values, which are mapped to elements in the specified
domain. The following range literals are also available: "width", "height",
"shapes", "category10", "category20".}

\item{reverse}{If true, flips the scale range.}

\item{round}{If true, rounds numeric output values to integers. This can be
helpful for snapping to the pixel grid.}

\item{utc}{if \code{TRUE}, uses UTC times. Default is \code{FALSE}.}

\item{clamp}{If \code{TRUE}, values that exceed the data domain are clamped
to either the minimum or maximum range value. Default is \code{FALSE}.}

\item{nice}{If specified, modifies the scale domain to use a more
human-friendly value range. Should be a string indicating the desired time
interval; legal values are "second", "minute", "hour", "day", "week",
"month", or "year".}

\item{expand}{A multiplier for how much the scale should be expanded beyond
the domain of the data. For example, if the data goes from 10 to 110, and
\code{expand} is 0.05, then the resulting domain of the scale is 5 to 115.
Set to 0 and use \code{nice=FALSE} if you want exact control over the
domain.}

\item{name}{Name of the scale, such as "x", "y", "fill", etc. Can also be an
arbitrary name like "foo".}

\item{label}{Label for the scale. Used for axis or legend titles.}

\item{override}{Should the domain specified by this ggvis_scale object
override other ggvis_scale objects for the same scale? Useful when domain is
manually specified. For example, by default, the domain of the scale
will contain the range of the data, but when this is TRUE, the specified
domain will override, and the domain can be smaller than the range of the
data. If \code{FALSE}, the \code{domain} will not behave this way. If
left \code{NULL}, then it will be treated as \code{TRUE} whenever
\code{domain} is non-NULL.}
}
\description{
A date/time scale controls the mapping of date and time variables to
visual properties.
}
\examples{
set.seed(2934)
dat <- data.frame(
  time = as.Date("2013-07-01") + 1:100,
  value = seq(1, 10, length.out = 100) + rnorm(100)
)
p <- dat \%>\% ggvis(~time, ~value) \%>\% layer_points()

# Start and end on month boundaries
p \%>\% scale_datetime("x", nice = "month")


dist <- data.frame(times = as.POSIXct("2013-07-01", tz = "GMT") +
                           rnorm(200) * 60 * 60 * 24 * 7)
p <- dist \%>\% ggvis(x = ~times) \%>\% layer_histograms()
p

# Start and end on month boundaries
p \%>\% scale_datetime("x", nice = "month")

p \%>\% scale_datetime("x", utc = TRUE)
}
\seealso{
\code{\link{scales}}, \code{\link{scale_numeric}},
  \url{https://github.com/trifacta/vega/wiki/Scales#time-scale-properties}

Other scales: \code{\link{scale_logical}},
  \code{\link{scale_nominal}}, \code{\link{scale_ordinal}};
  \code{\link{scale_numeric}}
}

