% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_voronoi.R
\name{geom_voronoi}
\alias{geom_voronoi}
\title{Voronoi Diagrams with ggplot2}
\usage{
geom_voronoi(
  mapping = NULL,
  data = NULL,
  stat = StatVoronoi,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  outline = NULL
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{outline}{\code{data.frame} with first column x/longitude, second column y/latitude, and a group column denoting islands or pieces.}
}
\description{
Convenience function for use with \code{\link[ggvoronoi]{stat_voronoi}}.
Uses \code{\link[ggplot2]{geom_polygon}} as the default geom and \code{\link[ggvoronoi]{stat_voronoi}} as the default stat.
To plot region borders instead of a choropleth map, use \code{\link[ggvoronoi]{stat_voronoi}} with \code{geom="path"},
or use \code{fill=NA} with \code{color="black"}.
}
\examples{
set.seed(45056)
x <- sample(1:200,100)
y <- sample(1:200,100)
points <- data.frame(x, y,
                     distance = sqrt((x-100)^2 + (y-100)^2))
circle <- data.frame(x = 100*(1+cos(seq(0, 2*pi, length.out = 2500))),
                     y = 100*(1+sin(seq(0, 2*pi, length.out = 2500))),
                     group = rep(1,2500))

ggplot(points) +
    geom_voronoi(aes(x=x,y=y,fill=distance))

ggplot(points) +
    geom_voronoi(aes(x=x,y=y,fill=distance),outline=circle)

ggplot(points) +
    geom_voronoi(aes(x=x,y=y,fill=distance),fill=NA,color="black")
}
\keyword{choropleth}
\concept{voronoi}
