% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.gimme.R
\name{residuals.gimme}
\alias{residuals.gimme}
\title{GIMME Residuals.}
\usage{
residuals.gimme(x, lag)
}
\arguments{
\item{x}{A fitted gimme object.}

\item{lag}{The number of lags tested in the Box-Pierce and Ljung-Box tests of the residuals.
If user does not specify a value, default is the smaller of 10 or the length of the time series divided by 5.}
}
\value{
List of four lists of data frames: \describe{ \item{residuals}{List of
  the unstandardized residuals per subject.}
  \item{standardized.residuals}{List of the standardized residuals per
  subject.}
  \item{Box.Pierce.test}{List of the results of the Box-Pierce test for each subject's residuals.}
  \item{Ljung.Box.test}{List of the results of the Ljung-Box test for each subject's residuals.}}
}
\description{
This function calculates the unstandardized and standardized
  residuals of a fitted gimme model.
}
\examples{
 \dontrun{
paths <- 'V2 ~ V1
          V3 ~ V4lag'

fit <- gimmeSEM(data     = simData,
                out      = "C:/simData_out",
                subgroup = TRUE,
                paths    = paths)

residuals <- residuals.gimme(fit)
residuals <- residuals.gimme(fit, lag = 5)
 }
}
\author{
Sebastian Castro-Alvarez
}
\keyword{internal}
