% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.paths.ind.R
\name{search.paths.ind}
\alias{search.paths.ind}
\title{Searches for individual-level paths. Ties together highest.mi, return.mis, prune, and get.params functions.}
\usage{
search.paths.ind(
  dat,
  k,
  data_list,
  base_syntax,
  fixed_syntax,
  elig_paths,
  prop_cutoff,
  n_subj,
  chisq_cutoff,
  subgroup_stage,
  hybrid,
  dir_prop_cutoff,
  ind_z_cutoff,
  rmsea_cutoff = 0.05,
  srmr_cutoff = 0.05,
  nnfi_cutoff = 0.95,
  cfi_cutoff = 0.95,
  n_excellent = 2
)
}
\arguments{
\item{dat}{Object created at beginning of gimme containing static info.}

\item{k}{Which individual this is.}

\item{data_list}{A list of datasets to be used in a given stage of the 
search. Varies based on group, subgroup, or individual-level stage.}

\item{base_syntax}{A character vector containing syntax that never changes.}

\item{fixed_syntax}{A character vector containing syntax that does not change
in a given stage of searching.}

\item{elig_paths}{A character vector containing eligible paths that
gimme is allowed to add to the model at a given stage.}

\item{prop_cutoff}{The proportion of individuals for whom a path must be
nonsignificant in order for it to be dropped from the models. NULL if used 
at the individual-level.}

\item{n_subj}{The number of subjects in a given stage of the search. If
in the group stage, n_subj equals the number of subjects. If in the subgroup
stage, n_subj equals the number of individuals in a given subgroup. At the 
individual stage, n_subj = 1.}

\item{chisq_cutoff}{Cutoff used in order for MI to be considered significant.
Value varies depending on stage of search (e.g., group, subgroup, 
individual).}

\item{subgroup_stage}{Logical. Only present in order to instruct gimme
what message to print to console using writeLines.}

\item{rmsea_cutoff}{Cutoff for RMSEA for an individual model(default is .05; must be between 0.0 and 1.0).}

\item{srmr_cutoff}{Cutoff for SRMR for an individual model (default is .05; must be between 0.0 and 1.0).}

\item{nnfi_cutoff}{Cutoff for NNFI for an individual model (default is .95; must be between 0.0 and 1.0).}

\item{cfi_cutoff}{Cutoff for CFI for an individual model (default is .95; must be between 0.0 and 1.0).}

\item{n_excellent}{Number of fit indices needed to surpass their cutoffs for an
individual model to be considered excellent. Default is 2. Max is 4.}
}
\value{
Returns updated values of n_paths and add_syntax.
}
\description{
Searches for individual-level paths. Ties together highest.mi, return.mis, prune, and get.params functions.
}
\keyword{internal}
