% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgin.R
\name{dgin}
\alias{dgin}
\title{Density for the generalized inverse normal distribution}
\usage{
dgin(z, alpha, mu, tau, log = TRUE, quasi = FALSE)
}
\arguments{
\item{z}{quantile.}

\item{alpha}{degrees-of-freedom parameter.}

\item{mu}{similar to location parameter, controls asymmetry of the distribution.}

\item{tau}{similar to scale parameter, controls spread of the distribution.}

\item{log}{logical; should the log of the density be returned? Defaults to TRUE.}

\item{quasi}{logical; should the quasi-density value be returned? Defaults to FALSE.}
}
\value{
Numeric scalar with density.
}
\description{
Density for the generalized inverse normal distribution
}
\details{
Currently, only scalars are supported for the quantile and parameter values.
Density is supported on the entire real line, \code{z} and \code{mu} can take any value
in \eqn{(-\infty, \infty)}. Density is only defined for parameter values
\code{alpha} > 1 or \code{tau} > 0, so it is set to 0 outside of these values.
The quasi-density or kernel is the density without the normalization constant,
use \code{quasi = TRUE} for this behavior.
}
\examples{
# Computing (log) density
dgin(z = 1, alpha = 3, mu = 1, tau = 1, log = TRUE, quasi = FALSE)

# Generalized inverse normal density with alpha = 5, mu = 0, tau = 1
z_vals <- seq(-5, 5, length.out = 200)
fz_unc <- sapply(z_vals, function(z) dgin(z, 5, 0, 1, FALSE))
plot(z_vals, fz_unc, type = "l", xlab = 'Values', ylab = 'Density')
}
