% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_healthcare.R
\name{gisco_get_healthcare}
\alias{gisco_get_healthcare}
\title{Get the healthcare services in Europe.}
\source{
\href{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/healthcare-services}{GISCO Healthcare services}
}
\usage{
gisco_get_healthcare(
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL
)
}
\arguments{
\item{cache, update_cache, cache_dir, verbose, country}{See \link{gisco_get}}
}
\value{
A \code{POINT} object.
}
\description{
The dataset contains information on main healthcare services considered to be 'hospitals' by Member States.
}
\details{
Files are distributed on EPSG:4326. \href{https://gisco-services.ec.europa.eu/pub/healthcare/metadata.pdf}{Link to metadata}
}
\examples{
library(sf)

if (gisco_check_access()) {
  HospitalBENELUX <- gisco_get_healthcare(country = c("BE", "NL", "LU"))
  BENELUX <- gisco_get_countries(country = c("BE", "NL", "LU"))
  plot(st_geometry(BENELUX))
  plot(
    st_geometry(HospitalBENELUX),
    pch = 20,
    col = "steelblue1",
    add = TRUE
  )
  title(main = "Hospitals in Benelux",
        sub = gisco_attributions(),
        line = 1)
}
}
\seealso{
\link{gisco_get}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
